/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.control;

import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.IntentionUtils;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.intentions.control.MergeElseIfPredicate;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;

public class MergeElseIfIntention
extends Intention {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        MergeElseIfPredicate mergeElseIfPredicate = new MergeElseIfPredicate();
        if (mergeElseIfPredicate == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/intentions/control/MergeElseIfIntention.getElementPredicate must not return null");
        }
        return mergeElseIfPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/intentions/control/MergeElseIfIntention.processIntention must not be null");
        }
        GrIfStatement parentStatement = (GrIfStatement)element;
        GrBlockStatement elseBlockStatement = (GrBlockStatement)parentStatement.getElseBranch();
        assert (elseBlockStatement != null);
        GrOpenBlock elseBranch = elseBlockStatement.getBlock();
        GrStatement elseBranchContents = elseBranch.getStatements()[0];
        IntentionUtils.replaceStatement("if(" + parentStatement.getCondition().getText() + ")" + parentStatement.getThenBranch().getText() + "else " + elseBranchContents.getText(), parentStatement);
    }
}

