/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.closure;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;

public class EachToForIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        EachToForPredicate eachToForPredicate = new EachToForPredicate();
        if (eachToForPredicate == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/intentions/closure/EachToForIntention.getElementPredicate must not return null");
        }
        return eachToForPredicate;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        String var;
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/intentions/closure/EachToForIntention.processIntention must not be null");
        }
        GrMethodCallExpression expression = (GrMethodCallExpression)element;
        GrClosableBlock block = expression.getClosureArguments()[0];
        GrParameterList parameterList = block.getParameterList();
        GrParameter[] parameters = parameterList.getParameters();
        if (parameters.length == 1) {
            var = parameters[0].getText();
            var = StringUtil.replace((String)var, (String)"def", (String)"");
        } else {
            var = "it";
        }
        GrExpression invokedExpression = expression.getInvokedExpression();
        GrExpression qualifier = ((GrReferenceExpression)invokedExpression).getQualifierExpression();
        GroovyPsiElementFactory elementFactory = GroovyPsiElementFactory.getInstance(element.getProject());
        if (qualifier == null) {
            qualifier = elementFactory.createExpressionFromText("this");
        }
        StringBuilder builder = new StringBuilder();
        builder.append("for (").append(var).append(" in ").append(qualifier.getText()).append(") {\n");
        String text = block.getText();
        int index = text.indexOf("->");
        index = index == -1 ? 1 : (index += 2);
        while (index < text.length() && Character.isWhitespace(text.charAt(index))) {
            ++index;
        }
        text = text.substring(index, text.length() - 1);
        builder.append(text);
        builder.append("}");
        GrStatement statement = elementFactory.createStatementFromText(builder.toString());
        expression.replaceWithStatement(statement);
    }

    private static class EachToForPredicate
    implements PsiElementPredicate {
        private EachToForPredicate() {
        }

        @Override
        public boolean satisfiedBy(PsiElement element) {
            GrReferenceExpression referenceExpression;
            GrMethodCallExpression expression;
            GrExpression invokedExpression;
            if (element instanceof GrMethodCallExpression && (invokedExpression = (expression = (GrMethodCallExpression)element).getInvokedExpression()) instanceof GrReferenceExpression && "each".equals((referenceExpression = (GrReferenceExpression)invokedExpression).getName())) {
                GrClosableBlock[] closureArguments;
                GrArgumentList argumentList = expression.getArgumentList();
                if (argumentList != null) {
                    if (argumentList.getExpressionArguments().length > 0) {
                        return false;
                    }
                    if (argumentList.getNamedArguments().length > 0) {
                        return false;
                    }
                }
                if ((closureArguments = expression.getClosureArguments()).length != 1) {
                    return false;
                }
                GrParameterList parameterList = closureArguments[0].getParameterList();
                if (parameterList == null) {
                    return false;
                }
                GrParameter[] parameters = parameterList.getParameters();
                return parameters.length <= 1;
            }
            return false;
        }
    }
}

