/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.gradle;

import com.intellij.compiler.options.CompileStepBeforeRun;
import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Location;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.NonClasspathDirectoryScope;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.extensions.GroovyScriptType;
import org.jetbrains.plugins.groovy.gradle.GradleConfigurable;
import org.jetbrains.plugins.groovy.gradle.GradleLibraryManager;
import org.jetbrains.plugins.groovy.gradle.GradleSettings;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.arithmetic.GrShiftExpressionImpl;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.runner.GroovyScriptRunConfiguration;
import org.jetbrains.plugins.groovy.runner.GroovyScriptRunner;
import org.jetbrains.plugins.groovy.util.GroovyUtils;

public class GradleScriptType
extends GroovyScriptType {
    @NonNls
    private static final String GRADLE_EXTENSION = "gradle";
    private static final Pattern MAIN_CLASS_NAME_PATTERN = Pattern.compile("\nSTARTER_MAIN_CLASS=(.*)\n");

    @Override
    public boolean isSpecificScriptFile(GroovyFile file) {
        return GRADLE_EXTENSION.equals(file.getViewProvider().getVirtualFile().getExtension());
    }

    @Override
    @NotNull
    public Icon getScriptIcon() {
        Icon icon = GradleLibraryManager.GRADLE_ICON;
        if (icon == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/gradle/GradleScriptType.getScriptIcon must not return null");
        }
        return icon;
    }

    @Override
    public void tuneConfiguration(@NotNull GroovyFile file, @NotNull GroovyScriptRunConfiguration configuration, Location location) {
        CompileStepBeforeRun.MakeBeforeRunTask runTask;
        String target;
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/gradle/GradleScriptType.tuneConfiguration must not be null");
        }
        if (configuration == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/plugins/groovy/gradle/GradleScriptType.tuneConfiguration must not be null");
        }
        PsiElement element = location.getPsiElement();
        PsiElement pp = element.getParent();
        PsiElement parent = element;
        while (!(pp instanceof PsiFile) && pp != null) {
            pp = pp.getParent();
            parent = parent.getParent();
        }
        if (pp != null && (target = GradleScriptType.getTaskTarget(parent)) != null) {
            configuration.scriptParams = target;
            configuration.setName(configuration.getName() + "." + target);
        }
        if ((runTask = (CompileStepBeforeRun.MakeBeforeRunTask)RunManagerEx.getInstanceEx((Project)element.getProject()).getBeforeRunTask((RunConfiguration)configuration, CompileStepBeforeRun.ID)) != null) {
            runTask.setEnabled(false);
        }
    }

    @Nullable
    private static String getTaskTarget(PsiElement parent) {
        if (GradleScriptType.isCreateTaskMethod(parent)) {
            GrExpression[] arguments = ((GrMethodCallExpression)parent).getExpressionArguments();
            if (arguments.length > 0 && arguments[0] instanceof GrLiteral && ((GrLiteral)arguments[0]).getValue() instanceof String) {
                return (String)((GrLiteral)arguments[0]).getValue();
            }
        } else if (parent instanceof GrApplicationStatement) {
            PsiElement shiftExpression = parent.getChildren()[1].getChildren()[0];
            if (shiftExpression instanceof GrShiftExpressionImpl) {
                PsiElement shiftiesChild = shiftExpression.getChildren()[0];
                if (shiftiesChild instanceof GrReferenceExpression) {
                    return shiftiesChild.getText();
                }
                if (shiftiesChild instanceof GrMethodCallExpression) {
                    return shiftiesChild.getChildren()[0].getText();
                }
            } else if (shiftExpression instanceof GrMethodCallExpression) {
                return shiftExpression.getChildren()[0].getText();
            }
        }
        return null;
    }

    private static boolean isCreateTaskMethod(PsiElement parent) {
        return parent instanceof GrMethodCallExpression && PsiUtil.isMethodCall((GrMethodCallExpression)parent, "createTask");
    }

    @Override
    public GroovyScriptRunner getRunner() {
        return new GroovyScriptRunner(){

            @Override
            public boolean isValidModule(@NotNull Module module) {
                if (module == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/gradle/GradleScriptType$1.isValidModule must not be null");
                }
                return GradleLibraryManager.isGradleSdk(ModuleRootManager.getInstance((Module)module).getFiles(OrderRootType.CLASSES));
            }

            @Override
            public boolean ensureRunnerConfigured(@Nullable Module module, String confName, Project project) throws ExecutionException {
                if (GradleLibraryManager.getSdkHome(module, project) == null) {
                    int result = Messages.showOkCancelDialog((String)"Gradle is not configured. Do you want to configure it?", (String)"Configure Gradle SDK", (Icon)GradleLibraryManager.GRADLE_ICON);
                    if (result == 0) {
                        ShowSettingsUtil util = ShowSettingsUtil.getInstance();
                        util.editConfigurable(project, util.findProjectConfigurable(project, GradleConfigurable.class));
                    }
                    if (GradleLibraryManager.getSdkHome(module, project) == null) {
                        return false;
                    }
                }
                return true;
            }

            @Override
            public void configureCommandLine(JavaParameters params, @Nullable Module module, boolean tests, VirtualFile script, GroovyScriptRunConfiguration configuration) throws CantRunException {
                VirtualFile groovyJar;
                Project project = configuration.getProject();
                VirtualFile gradleHome = GradleLibraryManager.getSdkHome(module, project);
                assert (gradleHome != null);
                params.setMainClass(GradleScriptType.findMainClass(gradleHome, script, project));
                File[] groovyJars = GroovyUtils.getFilesInDirectoryByPattern(gradleHome.getPath() + "/lib/", "groovy-all-(.*)\\.jar");
                if (groovyJars.length > 0) {
                    params.getClassPath().add(groovyJars[0].getAbsolutePath());
                } else if (module != null && (groovyJar = 1.findGroovyJar(module)) != null) {
                    params.getClassPath().add(groovyJar);
                }
                String userDefinedClasspath = System.getProperty("gradle.launcher.classpath");
                if (StringUtil.isNotEmpty((String)userDefinedClasspath)) {
                    params.getClassPath().add(userDefinedClasspath);
                } else {
                    params.getClassPath().addAllFiles(GroovyUtils.getFilesInDirectoryByPattern(gradleHome.getPath() + "/lib/", GradleLibraryManager.ANY_GRADLE_JAR_FILE_PATTERN));
                }
                params.getVMParametersList().addParametersString(configuration.vmParams);
                params.getVMParametersList().add("-Dgradle.home=" + FileUtil.toSystemDependentName((String)gradleHome.getPath()) + "");
                1.setToolsJar(params);
                params.getProgramParametersList().add("--build-file");
                params.getProgramParametersList().add(FileUtil.toSystemDependentName((String)configuration.scriptPath));
                params.getProgramParametersList().addParametersString(configuration.scriptParams);
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    private static String findMainClass(VirtualFile gradleHome, VirtualFile script, Project project) {
        PsiFile grFile;
        block5: {
            String string;
            String userDefined = System.getProperty("gradle.launcher.class");
            if (StringUtil.isNotEmpty((String)userDefined)) {
                String string2 = userDefined;
                string = string2;
                if (string2 != null) return string;
                throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/gradle/GradleScriptType.findMainClass must not return null");
            }
            VirtualFile launcher = gradleHome.findFileByRelativePath("bin/gradle");
            if (launcher == null) {
                launcher = gradleHome.findFileByRelativePath("bin/gradle.bat");
            }
            if (launcher != null) {
                String string3;
                try {
                    String candidate;
                    String text = StringUtil.convertLineSeparators((String)VfsUtil.loadText((VirtualFile)launcher));
                    Matcher matcher = MAIN_CLASS_NAME_PATTERN.matcher(text);
                    if (!matcher.find() || !StringUtil.isNotEmpty((String)(candidate = matcher.group(1)))) break block5;
                    string3 = candidate;
                }
                catch (IOException ignored) {
                    // empty catch block
                }
                string = string3;
                if (string3 == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/gradle/GradleScriptType.findMainClass must not return null");
                return string;
            }
        }
        if ((grFile = PsiManager.getInstance((Project)project).findFile(script)) == null) return "org.gradle.launcher.GradleMain";
        if (JavaPsiFacade.getInstance((Project)project).findClass("org.gradle.BootstrapMain", grFile.getResolveScope()) == null) return "org.gradle.launcher.GradleMain";
        return "org.gradle.BootstrapMain";
    }

    @Override
    public GlobalSearchScope patchResolveScope(@NotNull GroovyFile file, @NotNull GlobalSearchScope baseScope) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/gradle/GradleScriptType.patchResolveScope must not be null");
        }
        if (baseScope == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/plugins/groovy/gradle/GradleScriptType.patchResolveScope must not be null");
        }
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)file);
        if (module != null && GradleLibraryManager.getSdkHomeFromClasspath(module) != null) {
            return baseScope;
        }
        GradleSettings gradleSettings = GradleSettings.getInstance(file.getProject());
        VirtualFile home = gradleSettings.getSdkHome();
        if (home == null) {
            return baseScope;
        }
        List<VirtualFile> files = gradleSettings.getClassRoots();
        if (files.isEmpty()) {
            return baseScope;
        }
        GlobalSearchScope result = baseScope;
        for (VirtualFile root : files) {
            result = result.uniteWith((GlobalSearchScope)new NonClasspathDirectoryScope(root));
        }
        return result;
    }

    @Override
    public List<String> appendImplicitImports(@NotNull GroovyFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/gradle/GradleScriptType.appendImplicitImports must not be null");
        }
        return Arrays.asList("org.gradle", "org.gradle.util", "org.gradle.api", "org.gradle.api.artifacts", "org.gradle.api.artifacts.dsl", "org.gradle.api.artifacts.specs", "org.gradle.api.dependencies", "org.gradle.api.execution", "org.gradle.api.file", "org.gradle.api.logging", "org.gradle.api.initialization", "org.gradle.api.invocation", "org.gradle.api.plugins", "org.gradle.api.plugins.quality", "org.gradle.api.specs", "org.gradle.api.tasks", "org.gradle.api.tasks.bundling", "org.gradle.api.tasks.compile", "org.gradle.api.tasks.javadoc", "org.gradle.api.tasks.testing", "org.gradle.api.tasks.util", "org.gradle.api.tasks.wrapper");
    }
}

