/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.dsl;

import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import java.io.File;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.plugins.groovy.dsl.GroovyDslIndexedRootProvider;

public class AbstractDslIndexedRootsProvider
implements GroovyDslIndexedRootProvider {
    private final Set<String> ourDslsDirs;

    public AbstractDslIndexedRootsProvider() {
        File jarPath = new File(PathUtil.getJarPathForClass(this.getClass()));
        String dirPath = jarPath.isFile() ? new File(jarPath.getParentFile(), this.getScriptFolderName()).getAbsolutePath() : new File(jarPath, this.getScriptFolderName()).getAbsolutePath();
        VirtualFile parent = LocalFileSystem.getInstance().refreshAndFindFileByPath(dirPath);
        assert (parent != null) : dirPath;
        parent.getChildren();
        this.ourDslsDirs = Collections.singleton(parent.getUrl());
        parent.refresh(true, true);
    }

    protected String getScriptFolderName() {
        return "standardDsls";
    }

    public Set<String> getRootsToIndex() {
        return this.ourDslsDirs;
    }
}

