/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.config;

import com.intellij.facet.impl.ui.ProjectConfigurableContext;
import com.intellij.facet.ui.FacetEditorContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.libraries.ProjectLibraryTable;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.roots.ui.configuration.projectRoot.GlobalLibrariesConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesModifiableModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectLibrariesConfigurable;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.config.LibraryManager;
import org.jetbrains.plugins.groovy.config.ui.CreateLibraryDialog;

public abstract class AbstractGroovyLibraryManager
extends LibraryManager {
    public static final ExtensionPointName<AbstractGroovyLibraryManager> EP_NAME = ExtensionPointName.create((String)"org.intellij.groovy.libraryManager");

    @NotNull
    private static String generatePointerName(String version, String libPrefix, LibrariesContainer container, Set<String> usedLibraryNames) {
        String originalName;
        String newName = originalName = libPrefix + version;
        int index = 1;
        while (usedLibraryNames.contains(newName)) {
            newName = originalName + " (" + index + ")";
            ++index;
        }
        String string = newName;
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/config/AbstractGroovyLibraryManager.generatePointerName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String getAddActionText() {
        String string = "Create new " + this.getLibraryCategoryName() + " library...";
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/config/AbstractGroovyLibraryManager.getAddActionText must not return null");
        }
        return string;
    }

    public Icon getDialogIcon() {
        return this.getIcon();
    }

    protected abstract void fillLibrary(String var1, Library.ModifiableModel var2);

    @Nullable
    public final Library createSDKLibrary(String path, String name, Project project, boolean inModuleSettings, boolean inProject) {
        Library.ModifiableModel model;
        Library library;
        LibraryTable.ModifiableModel globalModel = null;
        if (inModuleSettings) {
            LibraryTable.ModifiableModel modifiableModel = globalModel = project != null && inProject ? ProjectLibrariesConfigurable.getInstance((Project)project).getModelProvider(true).getModifiableModel() : GlobalLibrariesConfigurable.getInstance((Project)project).getModelProvider(true).getModifiableModel();
            assert (globalModel != null);
            library = globalModel.createLibrary(name);
            model = ((LibrariesModifiableModel)globalModel).getLibraryEditor(library).getModel();
        } else {
            LibraryTable table = project != null && inProject ? ProjectLibraryTable.getInstance((Project)project) : LibraryTablesRegistrar.getInstance().getLibraryTable();
            library = LibraryUtil.createLibrary((LibraryTable)table, (String)name);
            model = library.getModifiableModel();
        }
        assert (library != null);
        this.fillLibrary(path, model);
        if (!inModuleSettings) {
            model.commit();
        } else {
            globalModel.commit();
        }
        return library;
    }

    @Override
    public Library createLibrary(@NotNull FacetEditorContext context) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/config/AbstractGroovyLibraryManager.createLibrary must not be null");
        }
        FileChooserDescriptor descriptor = new FileChooserDescriptor(false, true, false, false, false, false){

            public boolean isFileSelectable(VirtualFile file) {
                return super.isFileSelectable(file) && AbstractGroovyLibraryManager.this.isSDKHome(file);
            }
        };
        Project project = context.getModule().getProject();
        VirtualFile[] files = FileChooserFactory.getInstance().createFileChooser(descriptor, project).choose(null, project);
        if (files.length == 1) {
            return this.createLibrary(files[0].getPath(), ((ProjectConfigurableContext)context).getContainer(), true);
        }
        return null;
    }

    @Nullable
    public Library createLibrary(final @NotNull String path, LibrariesContainer container, final boolean inModuleSettings) {
        boolean addVersion;
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/config/AbstractGroovyLibraryManager.createLibrary must not be null");
        }
        ArrayList versions = CollectionFactory.arrayList();
        Set usedLibraryNames = CollectionFactory.newTroveSet((Object[])new Object[0]);
        for (Library library : container.getAllLibraries()) {
            usedLibraryNames.add(library.getName());
            if (!this.managesLibrary(library, container)) continue;
            ContainerUtil.addIfNotNull((Object)this.getLibraryVersion(library, container), (Collection)versions);
        }
        String newVersion = this.getSDKVersion(path);
        String libraryKind = this.getLibraryCategoryName();
        boolean bl = addVersion = !versions.contains(newVersion) || Messages.showOkCancelDialog((String)("Add one more " + libraryKind + " library of version " + newVersion + "?"), (String)"Duplicate library version", (Icon)this.getDialogIcon()) == 0;
        if (addVersion && !"undefined".equals(newVersion)) {
            final Project project = container.getProject();
            final String name = AbstractGroovyLibraryManager.generatePointerName(newVersion, this.getLibraryPrefix() + "-", container, usedLibraryNames);
            final CreateLibraryDialog dialog = new CreateLibraryDialog(project, "Create " + libraryKind + " library", "Create Project " + libraryKind + " library '" + name + "'", "Create Global " + libraryKind + " library '" + name + "'");
            dialog.show();
            if (dialog.isOK()) {
                return (Library)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<Library>(){

                    @Nullable
                    public Library compute() {
                        return AbstractGroovyLibraryManager.this.createSDKLibrary(path, name, project, inModuleSettings, dialog.isInProject());
                    }
                });
            }
        }
        return null;
    }
}

