/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.exception;

import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;

public class GroovyReturnFromFinallyBlockInspection
extends BaseInspection {
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        if ("Error handling" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/exception/GroovyReturnFromFinallyBlockInspection.getGroupDisplayName must not return null");
        }
        return "Error handling";
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("'return' inside 'finally' block" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/exception/GroovyReturnFromFinallyBlockInspection.getDisplayName must not return null");
        }
        return "'return' inside 'finally' block";
    }

    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return "'#ref' inside 'finally' block #loc";
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitReturnStatement(GrReturnStatement returnStatement) {
            super.visitReturnStatement(returnStatement);
            if (!ControlFlowUtils.isInFinallyBlock(returnStatement)) {
                return;
            }
            this.registerStatementError(returnStatement, new Object[0]);
        }
    }
}

