/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiWhiteSpace;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

public abstract class BaseInspectionVisitor
extends GroovyRecursiveElementVisitor {
    private BaseInspection inspection = null;
    private ProblemsHolder problemsHolder = null;
    private boolean onTheFly = false;
    private final List<ProblemDescriptor> errors = null;

    public void setInspection(BaseInspection inspection) {
        this.inspection = inspection;
    }

    public void setProblemsHolder(ProblemsHolder problemsHolder) {
        this.problemsHolder = problemsHolder;
    }

    public void setOnTheFly(boolean onTheFly) {
        this.onTheFly = onTheFly;
    }

    protected void registerStatementError(GrStatement statement, Object ... args) {
        PsiElement statementToken = statement.getFirstChild();
        this.registerError(statementToken, args);
    }

    protected void registerClassError(GrTypeDefinition aClass, Object ... args) {
        PsiElement statementToken = aClass.getNameIdentifierGroovy();
        this.registerError(statementToken, args);
    }

    protected void registerVariableError(GrVariable variable) {
        PsiElement nameIdentifier = variable.getNameIdentifierGroovy();
        this.registerError(nameIdentifier);
    }

    protected void registerModifierError(String modifier, PsiModifierListOwner parameter) {
        PsiElement[] children;
        PsiModifierList modifiers = parameter.getModifierList();
        if (modifiers == null) {
            return;
        }
        for (PsiElement child : children = modifiers.getChildren()) {
            String text = child.getText();
            if (!modifier.equals(text)) continue;
            this.registerError(child);
        }
    }

    protected void registerError(PsiElement location) {
        if (location == null) {
            return;
        }
        LocalQuickFix[] fix = this.createFixes(location);
        String description = this.inspection.buildErrorString(location);
        this.registerError(location, description, fix);
    }

    protected void registerMethodError(GrMethod method, Object ... args) {
        if (method == null) {
            return;
        }
        LocalQuickFix[] fix = this.createFixes(method);
        String description = this.inspection.buildErrorString(args);
        this.registerError(method.getNameIdentifierGroovy(), description, fix);
    }

    protected void registerVariableError(GrVariable variable, Object ... args) {
        if (variable == null) {
            return;
        }
        LocalQuickFix[] fix = this.createFixes(variable);
        String description = this.inspection.buildErrorString(args);
        this.registerError(variable.getNameIdentifierGroovy(), description, fix);
    }

    protected void registerMethodCallError(GrMethodCallExpression method, Object ... args) {
        if (method == null) {
            return;
        }
        LocalQuickFix[] fix = this.createFixes(method);
        String description = this.inspection.buildErrorString(args);
        this.registerError(((GrReferenceExpression)method.getInvokedExpression()).getReferenceNameElement(), description, fix);
    }

    private void registerError(@NotNull PsiElement location, String description, LocalQuickFix[] fixes) {
        if (location == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/codeInspection/BaseInspectionVisitor.registerError must not be null");
        }
        this.problemsHolder.registerProblem(location, description, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, fixes);
    }

    protected void registerError(@NotNull PsiElement location, Object ... args) {
        if (location == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/codeInspection/BaseInspectionVisitor.registerError must not be null");
        }
        LocalQuickFix[] fix = this.createFixes(location);
        String description = this.inspection.buildErrorString(args);
        this.registerError(location, description, fix);
    }

    @Nullable
    private LocalQuickFix[] createFixes(PsiElement location) {
        if (!this.onTheFly && this.inspection.buildQuickFixesOnlyForOnTheFlyErrors()) {
            return null;
        }
        LocalQuickFix[] fixes = this.inspection.buildFixes(location);
        if (fixes != null) {
            return fixes;
        }
        GroovyFix fix = this.inspection.buildFix(location);
        if (fix == null) {
            return null;
        }
        return new GroovyFix[]{fix};
    }

    @Nullable
    public ProblemDescriptor[] getErrors() {
        if (this.errors == null) {
            return null;
        }
        int numErrors = this.errors.size();
        return this.errors.toArray(new ProblemDescriptor[numErrors]);
    }

    public void visitWhiteSpace(PsiWhiteSpace space) {
    }
}

