/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.lang.reflect.Method;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.codeInspection.GroovySuppressableInspectionTool;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;

public abstract class BaseInspection
extends GroovySuppressableInspectionTool {
    private final String m_shortName;
    protected static final String ASSIGNMENT_ISSUES = "Assignment issues";
    protected static final String CONFUSING_CODE_CONSTRUCTS = "Potentially confusing code constructs";
    protected static final String CONTROL_FLOW = "Control Flow";
    protected static final String PROBABLE_BUGS = "Probable bugs";
    protected static final String ERROR_HANDLING = "Error handling";
    protected static final String GPATH = "GPath inspections";
    protected static final String METHOD_METRICS = "Method Metrics";
    protected static final String THREADING_ISSUES = "Threading issues";
    protected static final String VALIDITY_ISSUES = "Validity issues";
    protected static final String ANNOTATIONS_ISSUES = "Annotations verifying";

    public BaseInspection() {
        this.m_shortName = null;
    }

    @NotNull
    public String[] getGroupPath() {
        String[] stringArray = new String[]{"Groovy", this.getGroupDisplayName()};
        if (stringArray == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/BaseInspection.getGroupPath must not return null");
        }
        return stringArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String getShortName() {
        String string;
        if (this.m_shortName == null) {
            Class<?> aClass = ((Object)((Object)this)).getClass();
            String name = aClass.getName();
            string = name.substring(name.lastIndexOf(46) + 1, name.length() - "Inspection".length());
            if (string == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/BaseInspection.getShortName must not return null");
            return string;
        }
        string = this.m_shortName;
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/BaseInspection.getShortName must not return null");
    }

    @Nullable
    BaseInspectionVisitor buildGroovyVisitor(@NotNull ProblemsHolder problemsHolder, boolean onTheFly) {
        if (problemsHolder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/codeInspection/BaseInspection.buildGroovyVisitor must not be null");
        }
        BaseInspectionVisitor visitor = this.buildVisitor();
        visitor.setProblemsHolder(problemsHolder);
        visitor.setOnTheFly(onTheFly);
        visitor.setInspection(this);
        return visitor;
    }

    @Nullable
    protected String buildErrorString(Object ... args) {
        return null;
    }

    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return false;
    }

    @Nullable
    protected GroovyFix buildFix(PsiElement location) {
        return null;
    }

    @Nullable
    protected GroovyFix[] buildFixes(PsiElement location) {
        return null;
    }

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile psiFile, @NotNull InspectionManager inspectionManager, boolean isOnTheFly) {
        if (psiFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/codeInspection/BaseInspection.checkFile must not be null");
        }
        if (inspectionManager == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/plugins/groovy/codeInspection/BaseInspection.checkFile must not be null");
        }
        if (!(psiFile instanceof GroovyFile)) {
            return super.checkFile(psiFile, inspectionManager, isOnTheFly);
        }
        GroovyFile groovyFile = (GroovyFile)psiFile;
        ProblemsHolder problemsHolder = new ProblemsHolder(inspectionManager, psiFile, isOnTheFly);
        BaseInspectionVisitor visitor = this.buildGroovyVisitor(problemsHolder, isOnTheFly);
        groovyFile.accept(visitor);
        List problems = problemsHolder.getResults();
        if (problems == null) {
            return null;
        }
        return problems.toArray(new ProblemDescriptor[problems.size()]);
    }

    public boolean hasQuickFix() {
        Method[] methods;
        for (Method method : methods = ((Object)((Object)this)).getClass().getDeclaredMethods()) {
            String methodName = method.getName();
            if (!"buildFix".equals(methodName)) continue;
            return true;
        }
        return false;
    }

    protected abstract BaseInspectionVisitor buildVisitor();
}

