/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.editor.template.expressions.ChooseTypeExpression;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrVariableDeclarationOwner;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.GroovyExpectedTypesProvider;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.TypeConstraint;

public class CreateLocalVariableFromUsageFix
implements IntentionAction {
    private final GrVariableDeclarationOwner myOwner;
    private final GrReferenceExpression myRefExpression;

    public CreateLocalVariableFromUsageFix(GrReferenceExpression refExpression, GrVariableDeclarationOwner owner) {
        this.myRefExpression = refExpression;
        this.myOwner = owner;
    }

    @NotNull
    public String getText() {
        String string = GroovyBundle.message("create.variable.from.usage", this.myRefExpression.getReferenceName());
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/annotator/intentions/CreateLocalVariableFromUsageFix.getText must not return null");
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = GroovyBundle.message("create.from.usage.family.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/annotator/intentions/CreateLocalVariableFromUsageFix.getFamilyName must not return null");
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/annotator/intentions/CreateLocalVariableFromUsageFix.isAvailable must not be null");
        }
        return this.myOwner.isValid() && this.myRefExpression.isValid();
    }

    protected static Editor positionCursor(Project project, PsiFile targetFile, PsiElement element) {
        TextRange range = element.getTextRange();
        int textOffset = range.getStartOffset();
        VirtualFile vFile = targetFile.getVirtualFile();
        assert (vFile != null);
        OpenFileDescriptor descriptor = new OpenFileDescriptor(project, vFile, textOffset);
        return FileEditorManager.getInstance((Project)project).openTextEditor(descriptor, true);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/annotator/intentions/CreateLocalVariableFromUsageFix.invoke must not be null");
        }
        PsiClassType type = JavaPsiFacade.getInstance((Project)project).getElementFactory().createTypeByFQClassName("Object", GlobalSearchScope.allScope((Project)project));
        GrVariableDeclaration decl = GroovyPsiElementFactory.getInstance(project).createVariableDeclaration(ArrayUtil.EMPTY_STRING_ARRAY, null, (PsiType)type, this.myRefExpression.getReferenceName());
        int offset = this.myRefExpression.getTextRange().getStartOffset();
        GrStatement anchor = this.findAnchor(file, offset);
        TypeConstraint[] constraints = GroovyExpectedTypesProvider.calculateTypeConstraints(this.myRefExpression);
        decl = anchor.equals(this.myRefExpression) ? this.myRefExpression.replaceWithStatement(decl) : this.myOwner.addVariableDeclarationBefore(decl, anchor);
        GrTypeElement typeElement = decl.getTypeElementGroovy();
        assert (typeElement != null);
        ChooseTypeExpression expr = new ChooseTypeExpression(constraints, PsiManager.getInstance((Project)project));
        TemplateBuilderImpl builder = new TemplateBuilderImpl((PsiElement)decl);
        builder.replaceElement((PsiElement)typeElement, (Expression)expr);
        decl = (GrVariableDeclaration)CodeInsightUtilBase.forcePsiPostprocessAndRestoreElement((PsiElement)decl);
        Template template = builder.buildTemplate();
        Editor newEditor = CreateLocalVariableFromUsageFix.positionCursor(project, this.myOwner.getContainingFile(), decl);
        TextRange range = decl.getTextRange();
        newEditor.getDocument().deleteString(range.getStartOffset(), range.getEndOffset());
        TemplateManager manager = TemplateManager.getInstance((Project)project);
        manager.startTemplate(newEditor, template);
    }

    private GrStatement findAnchor(PsiFile file, int offset) {
        PsiElement element = file.findElementAt(offset);
        if (element == null && offset > 0) {
            element = file.findElementAt(offset - 1);
        }
        while (element != null) {
            if (this.myOwner.equals(element.getParent())) {
                return element instanceof GrStatement ? (GrStatement)element : null;
            }
            element = element.getParent();
        }
        return null;
    }

    public boolean startInWriteAction() {
        return true;
    }
}

