/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils;

import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.xml.ElementPresentationManager;
import com.intellij.util.xml.TypeNameManager;
import java.io.InputStream;
import javax.swing.Icon;
import org.jdom.Document;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.dom.MavenDomBundle;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.dom.model.MavenDomPlugin;
import org.jetbrains.idea.maven.dom.model.MavenDomRepository;
import org.jetbrains.idea.maven.utils.MavenIcons;

public class MavenDomApplicationComponent
implements ApplicationComponent {
    private static final Logger LOG = Logger.getInstance((String)MavenDomApplicationComponent.class.getName());
    @NonNls
    private static final String LIVE_TEMPLATES_DIR = "/liveTemplates/";
    @NonNls
    private static final String[] LIVE_TEMPLATES_FILES = new String[]{"maven_generate_dom.xml"};

    @NotNull
    public String getComponentName() {
        String string = MavenDomApplicationComponent.class.getName();
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/utils/MavenDomApplicationComponent.getComponentName must not return null");
        }
        return string;
    }

    public void initComponent() {
        MavenDomApplicationComponent.registerLiveTemplates();
        MavenDomApplicationComponent.registerPresentations();
    }

    private static void registerPresentations() {
        TypeNameManager.registerTypeName(MavenDomRepository.class, (String)MavenDomBundle.message("maven.repository", new Object[0]));
        TypeNameManager.registerTypeName(MavenDomPlugin.class, (String)MavenDomBundle.message("maven.plugin", new Object[0]));
        TypeNameManager.registerTypeName(MavenDomDependency.class, (String)MavenDomBundle.message("maven.dependency", new Object[0]));
        ElementPresentationManager.registerIcon(MavenDomRepository.class, (Icon)MavenIcons.PLUGIN_ICON);
        ElementPresentationManager.registerIcon(MavenDomDependency.class, (Icon)MavenIcons.DEPENDENCY_ICON);
        ElementPresentationManager.registerIcon(MavenDomPlugin.class, (Icon)MavenIcons.PLUGIN_ICON);
    }

    private static void registerLiveTemplates() {
        TemplateSettings settings = TemplateSettings.getInstance();
        for (String templatesFile : LIVE_TEMPLATES_FILES) {
            try {
                Document document = JDOMUtil.loadDocument((InputStream)MavenDomApplicationComponent.class.getResourceAsStream(LIVE_TEMPLATES_DIR + templatesFile));
                settings.readHiddenTemplateFile(document);
            }
            catch (Exception e) {
                LOG.error("Can't load " + templatesFile, (Throwable)e);
            }
        }
    }

    public void disposeComponent() {
    }
}

