/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import org.jetbrains.idea.maven.embedder.MavenConsole;
import org.jetbrains.idea.maven.project.MavenEmbeddersManager;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorTask;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;

public class MavenProjectsProcessorReadingTask
implements MavenProjectsProcessorTask {
    private final boolean myForce;
    private final MavenProjectsTree myTree;
    private final MavenGeneralSettings mySettings;
    private final List<VirtualFile> myFilesToUpdate;
    private final List<VirtualFile> myFilesToDelete;
    private final Object myMessage;

    public MavenProjectsProcessorReadingTask(boolean force, MavenProjectsTree tree, MavenGeneralSettings settings, Object message) {
        this(null, null, force, tree, settings, message);
    }

    public MavenProjectsProcessorReadingTask(List<VirtualFile> filesToUpdate, List<VirtualFile> filesToDelete, boolean force, MavenProjectsTree tree, MavenGeneralSettings settings, Object message) {
        this.myForce = force;
        this.myTree = tree;
        this.mySettings = settings;
        this.myFilesToUpdate = filesToUpdate;
        this.myFilesToDelete = filesToDelete;
        this.myMessage = message;
    }

    @Override
    public void perform(Project project, MavenEmbeddersManager embeddersManager, MavenConsole console, MavenProgressIndicator indicator) throws MavenProcessCanceledException {
        if (this.myFilesToUpdate == null) {
            this.myTree.updateAll(this.myForce, this.mySettings, indicator, this.myMessage);
        } else {
            this.myTree.delete(this.myFilesToDelete, this.mySettings, indicator, this.myMessage);
            this.myTree.update(this.myFilesToUpdate, this.myForce, this.mySettings, indicator, this.myMessage);
        }
    }
}

