/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MavenImportingSettings
implements Cloneable {
    private static final String PROCESS_RESOURCES_PHASE = "process-resources";
    public static final String[] UPDATE_FOLDERS_PHASES = new String[]{"generate-sources", "process-sources", "generate-resources", "process-resources", "generate-test-sources", "process-test-sources", "generate-test-resources", "process-test-resources"};
    public static final String UPDATE_FOLDERS_DEFAULT_PHASE = "process-resources";
    @NotNull
    private String dedicatedModuleDir = "";
    private boolean lookForNested = false;
    private boolean importAutomatically = false;
    private boolean createModulesForAggregators = true;
    private boolean createModuleGroups = false;
    private boolean useMavenOutput = true;
    private String updateFoldersOnImportPhase = "process-resources";
    private boolean downloadSourcesAutomatically = false;
    private boolean downloadDocsAutomatically = false;
    private List<Listener> myListeners = ContainerUtil.createEmptyCOWList();

    @NotNull
    public String getDedicatedModuleDir() {
        String string = this.dedicatedModuleDir;
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/project/MavenImportingSettings.getDedicatedModuleDir must not return null");
        }
        return string;
    }

    public void setDedicatedModuleDir(@NotNull String dedicatedModuleDir) {
        if (dedicatedModuleDir == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/project/MavenImportingSettings.setDedicatedModuleDir must not be null");
        }
        this.dedicatedModuleDir = dedicatedModuleDir;
    }

    public boolean isLookForNested() {
        return this.lookForNested;
    }

    public void setLookForNested(boolean lookForNested) {
        this.lookForNested = lookForNested;
    }

    public boolean isImportAutomatically() {
        return this.importAutomatically;
    }

    public void setImportAutomatically(boolean importAutomatically) {
        this.importAutomatically = importAutomatically;
        this.fireAutoImportChanged();
    }

    public boolean isCreateModuleGroups() {
        return this.createModuleGroups;
    }

    public void setCreateModuleGroups(boolean createModuleGroups) {
        this.createModuleGroups = createModuleGroups;
        this.fireCreateModuleGroupsChanged();
    }

    public boolean isCreateModulesForAggregators() {
        return this.createModulesForAggregators;
    }

    public void setCreateModulesForAggregators(boolean createModulesForAggregators) {
        this.createModulesForAggregators = createModulesForAggregators;
        this.fireCreateModuleForAggregatorsChanged();
    }

    public boolean isUseMavenOutput() {
        return this.useMavenOutput;
    }

    public void setUseMavenOutput(boolean useMavenOutput) {
        this.useMavenOutput = useMavenOutput;
    }

    public String getUpdateFoldersOnImportPhase() {
        return this.updateFoldersOnImportPhase;
    }

    public void setUpdateFoldersOnImportPhase(String updateFoldersOnImportPhase) {
        this.updateFoldersOnImportPhase = updateFoldersOnImportPhase;
    }

    public boolean isDownloadSourcesAutomatically() {
        return this.downloadSourcesAutomatically;
    }

    public void setDownloadSourcesAutomatically(boolean Value) {
        this.downloadSourcesAutomatically = Value;
    }

    public boolean isDownloadDocsAutomatically() {
        return this.downloadDocsAutomatically;
    }

    public void setDownloadDocsAutomatically(boolean value) {
        this.downloadDocsAutomatically = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MavenImportingSettings that = (MavenImportingSettings)o;
        if (this.createModuleGroups != that.createModuleGroups) {
            return false;
        }
        if (this.createModulesForAggregators != that.createModulesForAggregators) {
            return false;
        }
        if (this.importAutomatically != that.importAutomatically) {
            return false;
        }
        if (this.downloadDocsAutomatically != that.downloadDocsAutomatically) {
            return false;
        }
        if (this.downloadSourcesAutomatically != that.downloadSourcesAutomatically) {
            return false;
        }
        if (this.lookForNested != that.lookForNested) {
            return false;
        }
        if (this.useMavenOutput != that.useMavenOutput) {
            return false;
        }
        if (!this.dedicatedModuleDir.equals(that.dedicatedModuleDir)) {
            return false;
        }
        return !(this.updateFoldersOnImportPhase != null ? !this.updateFoldersOnImportPhase.equals(that.updateFoldersOnImportPhase) : that.updateFoldersOnImportPhase != null);
    }

    public int hashCode() {
        int result = this.dedicatedModuleDir.hashCode();
        result = 31 * result + (this.lookForNested ? 1 : 0);
        result = 31 * result + (this.importAutomatically ? 1 : 0);
        result = 31 * result + (this.createModulesForAggregators ? 1 : 0);
        result = 31 * result + (this.createModuleGroups ? 1 : 0);
        result = 31 * result + (this.useMavenOutput ? 1 : 0);
        result = 31 * result + (this.updateFoldersOnImportPhase != null ? this.updateFoldersOnImportPhase.hashCode() : 0);
        result = 31 * result + (this.downloadSourcesAutomatically ? 1 : 0);
        result = 31 * result + (this.downloadDocsAutomatically ? 1 : 0);
        return result;
    }

    public MavenImportingSettings clone() {
        try {
            MavenImportingSettings result = (MavenImportingSettings)super.clone();
            result.myListeners = ContainerUtil.createEmptyCOWList();
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }

    public void addListener(Listener l) {
        this.myListeners.add(l);
    }

    public void removeListener(Listener l) {
        this.myListeners.remove(l);
    }

    private void fireAutoImportChanged() {
        for (Listener each : this.myListeners) {
            each.autoImportChanged();
        }
    }

    private void fireCreateModuleGroupsChanged() {
        for (Listener each : this.myListeners) {
            each.createModuleGroupsChanged();
        }
    }

    private void fireCreateModuleForAggregatorsChanged() {
        for (Listener each : this.myListeners) {
            each.createModuleForAggregatorsChanged();
        }
    }

    public static interface Listener {
        public void autoImportChanged();

        public void createModuleGroupsChanged();

        public void createModuleForAggregatorsChanged();
    }
}

