/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import org.jetbrains.idea.maven.project.MavenProject;

public class MavenModuleNameMapper {
    public static void map(Collection<MavenProject> projects, Map<MavenProject, Module> mavenProjectToModule, Map<MavenProject, String> mavenProjectToModuleName, Map<MavenProject, String> mavenProjectToModulePath, String dedicatedModuleDir) {
        MavenModuleNameMapper.resolveModuleNames(projects, mavenProjectToModule, mavenProjectToModuleName);
        MavenModuleNameMapper.resolveModulePaths(projects, mavenProjectToModule, mavenProjectToModuleName, mavenProjectToModulePath, dedicatedModuleDir);
    }

    private static void resolveModuleNames(Collection<MavenProject> projects, Map<MavenProject, Module> mavenProjectToModule, Map<MavenProject, String> mavenProjectToModuleName) {
        ArrayList<NameItem> names = new ArrayList<NameItem>();
        for (MavenProject mavenProject : projects) {
            names.add(new NameItem(mavenProject, mavenProjectToModule.get(mavenProject)));
        }
        Collections.sort(names, new Comparator<NameItem>(){

            @Override
            public int compare(NameItem o1, NameItem o2) {
                return o1.project.getPath().compareToIgnoreCase(o2.project.getPath());
            }
        });
        for (NameItem nameItem : names) {
            if (nameItem.hasDuplicatedGroup) continue;
            String name = nameItem.getResultName();
            for (NameItem other : names) {
                if (nameItem == other || !name.equals(other.getResultName()) || !nameItem.groupId.equals(other.groupId)) continue;
                nameItem.setHasDuplicatedGroup(true);
                other.setHasDuplicatedGroup(true);
            }
        }
        for (NameItem nameItem : names) {
            int count = nameItem.number;
            if (count != -1) continue;
            count = 0;
            String name = nameItem.getResultName();
            for (NameItem other : names) {
                if (nameItem == other || !name.equals(other.getResultName())) continue;
                other.setNumber(++count);
            }
            if (count <= 0) continue;
            nameItem.setNumber(0);
        }
        for (NameItem nameItem : names) {
            mavenProjectToModuleName.put(nameItem.project, nameItem.getResultName());
        }
    }

    private static boolean isValidName(String name) {
        if (StringUtil.isEmptyOrSpaces((String)name)) {
            return false;
        }
        if (name.equals("Unknown")) {
            return false;
        }
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (Character.isDigit(ch) || Character.isLetter(ch) || ch == '-' || ch == '_' || ch == '.') continue;
            return false;
        }
        return true;
    }

    private static void resolveModulePaths(Collection<MavenProject> projects, Map<MavenProject, Module> mavenProjectToModule, Map<MavenProject, String> mavenProjectToModuleName, Map<MavenProject, String> mavenProjectToModulePath, String dedicatedModuleDir) {
        for (MavenProject each : projects) {
            Module module = mavenProjectToModule.get(each);
            String path = module != null ? module.getModuleFilePath() : MavenModuleNameMapper.generateModulePath(each, mavenProjectToModuleName, dedicatedModuleDir);
            mavenProjectToModulePath.put(each, path);
        }
    }

    private static String generateModulePath(MavenProject project, Map<MavenProject, String> mavenProjectToModuleName, String dedicatedModuleDir) {
        String dir = StringUtil.isEmptyOrSpaces((String)dedicatedModuleDir) ? project.getDirectory() : dedicatedModuleDir;
        String fileName = mavenProjectToModuleName.get(project) + ".iml";
        return new File(dir, fileName).getPath();
    }

    public static class NameItem {
        public final MavenProject project;
        public final Module module;
        public final String originalName;
        public final String groupId;
        public int number = -1;
        public boolean hasDuplicatedGroup;

        public NameItem(MavenProject project, Module module) {
            this.project = project;
            this.module = module;
            this.originalName = this.calcOriginalName();
            String group = project.getMavenId().getGroupId();
            this.groupId = MavenModuleNameMapper.isValidName(group) ? group : "";
        }

        private String calcOriginalName() {
            if (this.module != null) {
                return this.module.getName();
            }
            String name = this.project.getMavenId().getArtifactId();
            if (!MavenModuleNameMapper.isValidName(name)) {
                name = this.project.getDirectoryFile().getName();
            }
            return name;
        }

        public void setNumber(int num) {
            this.number = num;
        }

        public void setHasDuplicatedGroup(boolean value) {
            this.hasDuplicatedGroup = value;
        }

        public String getResultName() {
            if (this.module != null) {
                return this.module.getName();
            }
            if (this.number == -1) {
                return this.originalName;
            }
            String result = this.originalName + " (" + (this.number + 1) + ")";
            if (!this.hasDuplicatedGroup && this.groupId.length() != 0) {
                result = result + " (" + this.groupId + ")";
            }
            return result;
        }
    }
}

