/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.embedder.MavenConsole;
import org.jetbrains.idea.maven.embedder.MavenConsoleHelper;
import org.jetbrains.idea.maven.embedder.MavenConsoleImpl;
import org.jetbrains.idea.maven.execution.MavenExecutor;
import org.jetbrains.idea.maven.execution.MavenExternalExecutor;
import org.jetbrains.idea.maven.execution.MavenRunnerParameters;
import org.jetbrains.idea.maven.execution.MavenRunnerSettings;
import org.jetbrains.idea.maven.execution.SoutMavenConsole;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.SimpleProjectComponent;

@State(name="MavenRunner", storages={@Storage(id="default", file="$WORKSPACE_FILE$")})
public class MavenRunner
extends SimpleProjectComponent
implements PersistentStateComponent<MavenRunnerSettings> {
    private MavenRunnerSettings mySettings = new MavenRunnerSettings();

    public static MavenRunner getInstance(Project project) {
        return (MavenRunner)((Object)project.getComponent(MavenRunner.class));
    }

    public MavenRunner(Project project) {
        super(project);
    }

    public MavenRunnerSettings getSettings() {
        return this.mySettings;
    }

    public MavenRunnerSettings getState() {
        return this.mySettings;
    }

    public void loadState(MavenRunnerSettings settings) {
        this.mySettings = settings;
    }

    public void run(MavenRunnerParameters parameters, final MavenRunnerSettings settings, final Runnable onComplete) {
        FileDocumentManager.getInstance().saveAllDocuments();
        final MavenConsole console = this.createConsole(this.getGeneralSettings(), (Pair<MavenRunnerParameters, MavenRunnerSettings>)Pair.create((Object)parameters, (Object)settings));
        try {
            final MavenExecutor[] executor = new MavenExecutor[]{this.createExecutor(parameters, this.getGeneralSettings(), settings, console)};
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, executor[0].getCaption(), true){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/execution/MavenRunner$1.run must not be null");
                    }
                    try {
                        try {
                            if (executor[0].execute(indicator) && onComplete != null) {
                                onComplete.run();
                            }
                        }
                        catch (ProcessCanceledException processCanceledException) {
                            // empty catch block
                        }
                        executor[0] = null;
                        MavenRunner.this.updateTargetFolders();
                    }
                    finally {
                        console.finish();
                    }
                }

                @Nullable
                public Task.NotificationInfo getNotificationInfo() {
                    return new Task.NotificationInfo("Maven", "Maven Task Finished", "");
                }

                public boolean shouldStartInBackground() {
                    return settings.isRunMavenInBackground();
                }

                public void processSentToBackground() {
                    settings.setRunMavenInBackground(true);
                }

                public void processRestoredToForeground() {
                    settings.setRunMavenInBackground(false);
                }
            });
        }
        catch (Exception e) {
            MavenConsoleHelper.printException(console, e);
            console.finish();
            MavenLog.LOG.warn((Throwable)e);
        }
    }

    private MavenGeneralSettings getGeneralSettings() {
        return MavenProjectsManager.getInstance(this.myProject).getGeneralSettings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean runBatch(List<MavenRunnerParameters> commands, @Nullable MavenGeneralSettings coreSettings, @Nullable MavenRunnerSettings runnerSettings, @Nullable String action, ProgressIndicator indicator) {
        if (commands.isEmpty()) {
            return true;
        }
        MavenGeneralSettings effectiveCoreSettings = coreSettings != null ? coreSettings : this.getGeneralSettings();
        MavenRunnerSettings effectiveRunnerSettings = runnerSettings != null ? runnerSettings : this.getState();
        MavenConsole console = this.createConsole(effectiveCoreSettings, null);
        try {
            int count = 0;
            for (MavenRunnerParameters command : commands) {
                if (indicator != null) {
                    indicator.setFraction((double)count++ / (double)commands.size());
                }
                MavenExecutor executor = this.createExecutor(command, effectiveCoreSettings, effectiveRunnerSettings, console);
                executor.setAction(action);
                if (executor.execute(indicator)) continue;
                this.updateTargetFolders();
                boolean bl = false;
                return bl;
            }
            this.updateTargetFolders();
        }
        finally {
            console.finish();
        }
        return true;
    }

    private void updateTargetFolders() {
        if (this.myProject.isDisposed()) {
            return;
        }
        MavenProjectsManager.getInstance(this.myProject).updateProjectTargetFolders();
    }

    private MavenConsole createConsole(MavenGeneralSettings coreSettings, Pair<MavenRunnerParameters, MavenRunnerSettings> parametersAndSettings) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return new SoutMavenConsole();
        }
        return new MavenConsoleImpl("Maven Goal", this.myProject);
    }

    private MavenExecutor createExecutor(MavenRunnerParameters taskParameters, MavenGeneralSettings coreSettings, MavenRunnerSettings runnerSettings, MavenConsole console) {
        return new MavenExternalExecutor(taskParameters, coreSettings, runnerSettings, console);
    }
}

