/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.embedder;

import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.AbstractArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.DefaultArtifactResolver;
import org.jetbrains.idea.maven.embedder.UnresolvedArtifactsCollector;
import org.jetbrains.idea.maven.project.MavenId;

public class CustomArtifactResolver
extends DefaultArtifactResolver {
    private Map<MavenId, VirtualFile> myProjectIdToFileMap;
    private UnresolvedArtifactsCollector myUnresolvedCollector;

    public void customize(Map<MavenId, VirtualFile> projectIdToFileMap, boolean failOnUnresolved) {
        this.myProjectIdToFileMap = projectIdToFileMap;
        this.myUnresolvedCollector = new UnresolvedArtifactsCollector(failOnUnresolved);
    }

    public void reset() {
        this.myProjectIdToFileMap = null;
        this.myUnresolvedCollector = null;
    }

    public UnresolvedArtifactsCollector getUnresolvedCollector() {
        return this.myUnresolvedCollector;
    }

    public void resolve(Artifact artifact, List remoteRepositories, ArtifactRepository localRepository) throws ArtifactResolutionException, ArtifactNotFoundException {
        if (this.resolveAsModule(artifact)) {
            return;
        }
        try {
            super.resolve(artifact, remoteRepositories, localRepository);
        }
        catch (AbstractArtifactResolutionException e) {
            this.myUnresolvedCollector.collectAndSetResolved(artifact);
        }
    }

    public void resolveAlways(Artifact artifact, List remoteRepositories, ArtifactRepository localRepository) throws ArtifactResolutionException, ArtifactNotFoundException {
        if (this.resolveAsModule(artifact)) {
            return;
        }
        try {
            super.resolveAlways(artifact, remoteRepositories, localRepository);
        }
        catch (AbstractArtifactResolutionException e) {
            this.myUnresolvedCollector.collectAndSetResolved(artifact);
        }
    }

    private boolean resolveAsModule(Artifact a) {
        Map<MavenId, VirtualFile> map = this.myProjectIdToFileMap;
        if (map == null) {
            return false;
        }
        VirtualFile file = map.get(new MavenId(a));
        if (file == null) {
            return false;
        }
        a.setResolved(true);
        a.setFile(new File(file.getPath()));
        return true;
    }
}

