/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.converters;

import com.intellij.psi.PsiElement;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.ResolvingConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenPluginDomUtil;
import org.jetbrains.idea.maven.dom.plugin.MavenDomMojo;
import org.jetbrains.idea.maven.dom.plugin.MavenDomPluginModel;

public class MavenPluginGoalConverter
extends ResolvingConverter<String> {
    public String fromString(@Nullable @NonNls String s, ConvertContext context) {
        return this.getVariants(context).contains(s) ? s : null;
    }

    public String toString(@Nullable String s, ConvertContext context) {
        return s;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Collection<String> getVariants(ConvertContext context) {
        List<String> list;
        MavenDomPluginModel model = MavenPluginDomUtil.getMavenPluginModel(context.getInvocationElement());
        if (model == null) {
            list = Collections.emptyList();
            if (list == null) throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/dom/converters/MavenPluginGoalConverter.getVariants must not return null");
            return list;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (MavenDomMojo each : model.getMojos().getMojos()) {
            String goal = each.getGoal().getStringValue();
            if (goal == null) continue;
            result.add(goal);
        }
        list = result;
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/dom/converters/MavenPluginGoalConverter.getVariants must not return null");
    }

    public PsiElement resolve(String text, ConvertContext context) {
        MavenDomPluginModel model = MavenPluginDomUtil.getMavenPluginModel(context.getInvocationElement());
        if (model == null) {
            return null;
        }
        for (MavenDomMojo each : model.getMojos().getMojos()) {
            String goal = each.getGoal().getStringValue();
            if (!text.equals(goal)) continue;
            return each.getXmlElement();
        }
        return super.resolve((Object)text, context);
    }
}

