/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.annotator;

import com.intellij.codeInsight.navigation.NavigationGutterIconBuilder;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomBundle;
import org.jetbrains.idea.maven.dom.MavenDomProjectProcessorUtils;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.dom.model.MavenDomDependencyManagement;
import org.jetbrains.idea.maven.dom.model.MavenDomParent;
import org.jetbrains.idea.maven.dom.model.MavenDomPlugin;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.project.MavenId;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenIcons;

public class MavenDomGutterAnnotator
implements Annotator {
    private static final PsiElementListCellRenderer<XmlTag> RENDERER = new PsiElementListCellRenderer<XmlTag>(){

        public String getElementText(XmlTag tag) {
            String name;
            MavenDomProjectModel model;
            DomElement domElement = DomManager.getDomManager((Project)tag.getProject()).getDomElement(tag);
            if (domElement != null && (model = (MavenDomProjectModel)domElement.getParentOfType(MavenDomProjectModel.class, false)) != null && !StringUtil.isEmptyOrSpaces((String)(name = model.getName().getStringValue()))) {
                return name;
            }
            return tag.getContainingFile().getName();
        }

        protected String getContainerText(XmlTag element, String name) {
            return null;
        }

        protected Icon getIcon(PsiElement element) {
            return MavenIcons.MAVEN_PROJECT_ICON;
        }

        protected int getIconFlags() {
            return 0;
        }
    };
    private static final NotNullFunction<MavenDomDependency, Collection<? extends PsiElement>> CONVERTER = new NotNullFunction<MavenDomDependency, Collection<? extends PsiElement>>(){

        @NotNull
        public Collection<? extends PsiElement> fun(MavenDomDependency pointer) {
            List list = ContainerUtil.createMaybeSingletonList((Object)pointer.getXmlTag());
            if (list == null) {
                throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/dom/annotator/MavenDomGutterAnnotator$2.fun must not return null");
            }
            return list;
        }
    };
    private static final NotNullFunction<MavenDomProjectModel, Collection<? extends PsiElement>> MAVEN_PROJECT_CONVERTER = new NotNullFunction<MavenDomProjectModel, Collection<? extends PsiElement>>(){

        @NotNull
        public Collection<? extends PsiElement> fun(MavenDomProjectModel pointer) {
            List list = ContainerUtil.createMaybeSingletonList((Object)pointer.getXmlTag());
            if (list == null) {
                throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/dom/annotator/MavenDomGutterAnnotator$3.fun must not return null");
            }
            return list;
        }
    };

    private static void annotateDependencyUsages(@NotNull MavenDomDependency dependency, AnnotationHolder holder) {
        if (dependency == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/dom/annotator/MavenDomGutterAnnotator.annotateDependencyUsages must not be null");
        }
        XmlTag tag = dependency.getXmlTag();
        if (tag == null) {
            return;
        }
        Set<MavenDomDependency> children = MavenDomGutterAnnotator.getDependencyUsages(dependency);
        if (children.size() > 0) {
            NavigationGutterIconBuilder iconBuilder = NavigationGutterIconBuilder.create((Icon)MavenIcons.OVERRIDEN_DEPENDENCY, CONVERTER);
            iconBuilder.setTargets(children).setPopupTitle(MavenDomBundle.message("navigate.parent.dependency.title", new Object[0])).setCellRenderer(RENDERER).setTooltipText(MavenDomBundle.message("overriding.dependency.title", new Object[0])).install(holder, (PsiElement)dependency.getXmlTag());
        }
    }

    private static void annotateManagedDependency(MavenDomDependency dependency, AnnotationHolder holder) {
        XmlTag tag = dependency.getXmlTag();
        if (tag == null) {
            return;
        }
        List<MavenDomDependency> children = MavenDomGutterAnnotator.getManagingDependencies(dependency);
        if (children.size() > 0) {
            NavigationGutterIconBuilder iconBuilder = NavigationGutterIconBuilder.create((Icon)MavenIcons.OVERRIDING_DEPENDENCY, CONVERTER);
            iconBuilder.setTargets(children).setTooltipText(MavenDomBundle.message("overriden.dependency.title", new Object[0])).install(holder, (PsiElement)dependency.getXmlTag());
        }
    }

    private static List<MavenDomDependency> getManagingDependencies(@NotNull MavenDomDependency dependency) {
        if (dependency == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/dom/annotator/MavenDomGutterAnnotator.getManagingDependencies must not be null");
        }
        Project project = dependency.getManager().getProject();
        MavenDomDependency parentDependency = MavenDomProjectProcessorUtils.searchManagingDependency(dependency, project);
        if (parentDependency != null) {
            return Collections.singletonList(parentDependency);
        }
        return Collections.emptyList();
    }

    @NotNull
    private static Set<MavenDomDependency> getDependencyUsages(@NotNull MavenDomDependency dependency) {
        if (dependency == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/dom/annotator/MavenDomGutterAnnotator.getDependencyUsages must not be null");
        }
        Set<MavenDomDependency> set = MavenDomProjectProcessorUtils.searchDependencyUsages(dependency, dependency.getManager().getProject());
        if (set == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/dom/annotator/MavenDomGutterAnnotator.getDependencyUsages must not return null");
        }
        return set;
    }

    public void annotate(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        if (psiElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/dom/annotator/MavenDomGutterAnnotator.annotate must not be null");
        }
        if (holder == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/idea/maven/dom/annotator/MavenDomGutterAnnotator.annotate must not be null");
        }
        if (psiElement instanceof XmlTag) {
            DomElement element = DomManager.getDomManager((Project)psiElement.getProject()).getDomElement((XmlTag)psiElement);
            if (element instanceof MavenDomDependency) {
                if (element.getParentOfType(MavenDomPlugin.class, true) != null) {
                    return;
                }
                MavenDomDependency dependency = (MavenDomDependency)element;
                if (MavenDomGutterAnnotator.isDependencyManagementSection(dependency)) {
                    MavenDomGutterAnnotator.annotateDependencyUsages(dependency, holder);
                } else {
                    MavenDomGutterAnnotator.annotateManagedDependency(dependency, holder);
                }
            } else if (element instanceof MavenDomParent) {
                MavenDomGutterAnnotator.annotateMavenDomParent((MavenDomParent)element, holder);
            } else if (element instanceof MavenDomProjectModel) {
                MavenDomGutterAnnotator.annotateMavenDomProjectChildren((MavenDomProjectModel)element, holder);
            }
        }
    }

    private static void annotateMavenDomParent(@NotNull MavenDomParent mavenDomParent, @NotNull AnnotationHolder holder) {
        if (mavenDomParent == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/dom/annotator/MavenDomGutterAnnotator.annotateMavenDomParent must not be null");
        }
        if (holder == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/idea/maven/dom/annotator/MavenDomGutterAnnotator.annotateMavenDomParent must not be null");
        }
        MavenDomProjectModel parent = MavenDomGutterAnnotator.findParent(mavenDomParent, mavenDomParent.getManager().getProject());
        if (parent != null) {
            NavigationGutterIconBuilder.create((Icon)MavenIcons.PARENT_PROJECT, MAVEN_PROJECT_CONVERTER).setTargets((Object[])new MavenDomProjectModel[]{parent}).setTooltipText(MavenDomBundle.message("parent.pom.title", new Object[0])).install(holder, (PsiElement)mavenDomParent.getXmlElement());
        }
    }

    private static void annotateMavenDomProjectChildren(MavenDomProjectModel model, AnnotationHolder holder) {
        Project project;
        Set<MavenProject> inheritors;
        List children;
        MavenProject mavenProject = MavenDomUtil.findProject(model);
        if (mavenProject != null && (children = ContainerUtil.mapNotNull(inheritors = MavenProjectsManager.getInstance(project = model.getManager().getProject()).findInheritors(mavenProject), (Function)new Function<MavenProject, MavenDomProjectModel>(){

            public MavenDomProjectModel fun(MavenProject childProject) {
                return MavenDomUtil.getMavenDomProjectModel(project, childProject.getFile());
            }
        })).size() > 0) {
            NavigationGutterIconBuilder.create((Icon)MavenIcons.CHILDREN_PROJECTS, MAVEN_PROJECT_CONVERTER).setTargets((Collection)children).setCellRenderer(RENDERER).setPopupTitle(MavenDomBundle.message("navigate.children.poms.title", new Object[0])).setTooltipText(MavenDomBundle.message("children.poms.title", new Object[0])).install(holder, (PsiElement)model.getXmlElement());
        }
    }

    @Nullable
    public static MavenDomProjectModel findParent(@NotNull MavenDomParent mavenDomParent, Project project) {
        if (mavenDomParent == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/dom/annotator/MavenDomGutterAnnotator.findParent must not be null");
        }
        if (!DomUtil.hasXml((DomElement)mavenDomParent)) {
            return null;
        }
        MavenId id = new MavenId(mavenDomParent.getGroupId().getStringValue(), mavenDomParent.getArtifactId().getStringValue(), mavenDomParent.getVersion().getStringValue());
        MavenProject mavenProject = MavenProjectsManager.getInstance(project).findProject(id);
        return mavenProject != null ? MavenDomUtil.getMavenDomProjectModel(project, mavenProject.getFile()) : null;
    }

    private static boolean isDependencyManagementSection(@NotNull MavenDomDependency dependency) {
        if (dependency == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/dom/annotator/MavenDomGutterAnnotator.isDependencyManagementSection must not be null");
        }
        return dependency.getParentOfType(MavenDomDependencyManagement.class, false) != null;
    }
}

