/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNHashSet;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNAdminUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNExternal;
import org.tmatesoft.svn.core.internal.wc.SVNFileListUtil;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNPropertiesManager;
import org.tmatesoft.svn.core.internal.wc.SVNWCProperties;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaFactory;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaInfo;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNLog;
import org.tmatesoft.svn.core.internal.wc.admin.SVNVersionedProperties;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNStatusHandler;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusClient;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNWCManager {
    public static final int SCHEDULE = 1;
    public static final int COPIED = 2;
    public static final int KEEP_LOCAL = 4;

    public static void add(File path, SVNAdminArea parentDir, SVNURL copyFromURL, SVNRevision copyFromRev, SVNDepth depth) throws SVNException {
        SVNWCManager.add(path, parentDir, copyFromURL, copyFromRev.getNumber(), depth);
    }

    public static void add(File path, SVNAdminArea parentDir, SVNURL copyFromURL, long copyFromRev, SVNDepth depth) throws SVNException {
        SVNErrorMessage err;
        SVNEntry parentEntry;
        SVNErrorMessage err2;
        SVNWCAccess wcAccess = parentDir.getWCAccess();
        SVNFileType fileType = SVNFileType.getType(path);
        if (fileType == SVNFileType.NONE) {
            err2 = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "''{0}'' not found", path);
            SVNErrorManager.error(err2, SVNLogType.WC);
        } else if (fileType == SVNFileType.UNKNOWN) {
            err2 = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "Unsupported node kind for path ''{0}''", path);
            SVNErrorManager.error(err2, SVNLogType.WC);
        }
        SVNAdminArea dir = fileType == SVNFileType.SYMLINK ? wcAccess.probeTry(path.getParentFile(), true, copyFromURL != null ? -1 : 0) : wcAccess.probeTry(path, true, copyFromURL != null ? -1 : 0);
        SVNEntry entry = null;
        if (dir != null) {
            entry = wcAccess.getEntry(path, true);
        }
        boolean replace = false;
        SVNNodeKind kind = SVNFileType.getNodeKind(fileType);
        if (entry != null) {
            SVNErrorMessage err3;
            if (copyFromURL == null && !entry.isScheduledForDeletion() && !entry.isDeleted() || entry.getDepth() == SVNDepth.EXCLUDE) {
                err3 = SVNErrorMessage.create(SVNErrorCode.ENTRY_EXISTS, "''{0}'' is already under version control", path);
                SVNErrorManager.error(err3, SVNLogType.WC);
            } else if (entry.getKind() != kind) {
                err3 = SVNErrorMessage.create(SVNErrorCode.WC_NODE_KIND_CHANGE, "Can''t replace ''{0}'' with a node of a different type; the deletion must be committed and the parent updated before adding ''{0}''", path);
                SVNErrorManager.error(err3, SVNLogType.WC);
            }
            replace = entry.isScheduledForDeletion();
        }
        if ((parentEntry = wcAccess.getEntry(path.getParentFile(), false)) == null) {
            err = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "Can''t find parent directory''s entry while trying to add ''{0}''", path);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (parentEntry.isScheduledForDeletion()) {
            err = SVNErrorMessage.create(SVNErrorCode.WC_SCHEDULE_CONFLICT, "Can''t add ''{0}'' to a parent directory scheduled for deletion", path);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        SVNHashMap command = new SVNHashMap();
        String name = path.getName();
        if (copyFromURL != null) {
            if (parentEntry.getRepositoryRoot() != null && !SVNPathUtil.isAncestor(parentEntry.getRepositoryRoot(), copyFromURL.toString())) {
                SVNErrorMessage err4 = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "The URL ''{0}'' has a different repository root than its parent", copyFromURL);
                SVNErrorManager.error(err4, SVNLogType.WC);
            }
            command.put("svn:entry:copyfrom-url", copyFromURL.toString());
            command.put("svn:entry:copyfrom-rev", SVNProperty.toString(copyFromRev));
            command.put("svn:entry:copied", Boolean.TRUE.toString());
        }
        if (replace) {
            command.put("svn:entry:checksum", null);
            command.put("svn:entry:has-props", Boolean.FALSE.toString());
            command.put("svn:entry:has-prop-mods", Boolean.FALSE.toString());
        }
        command.put("svn:entry:schedule", "add");
        command.put("svn:entry:kind", SVNFileType.getNodeKind(fileType).toString());
        if (!replace && copyFromURL == null) {
            command.put("svn:entry:revision", "0");
        }
        parentDir.modifyEntry(name, command, true, false);
        if (entry != null && copyFromURL == null) {
            String propPath = SVNAdminUtil.getPropPath(name, entry.getKind(), false);
            File propFile = dir.getFile(propPath);
            SVNFileUtil.deleteFile(propFile);
        }
        if (replace) {
            SVNProperties props = new SVNProperties();
            if (entry.getKind() == SVNNodeKind.FILE) {
                SVNLog log = parentDir.getLog();
                props.put("name", SVNAdminUtil.getTextBasePath(entry.getName(), false));
                props.put("dest", SVNAdminUtil.getTextRevertPath(entry.getName(), false));
                log.addCommand("mv", props, false);
                log.save();
                parentDir.runLogs();
            }
            SVNWCManager.createRevertProperties(wcAccess, path, true);
        }
        if (kind == SVNNodeKind.DIR) {
            if (copyFromURL == null) {
                SVNEntry pEntry = wcAccess.getEntry(path.getParentFile(), false);
                SVNURL newURL = pEntry.getSVNURL().appendPath(name, false);
                SVNURL rootURL = pEntry.getRepositoryRootURL();
                String uuid = pEntry.getUUID();
                SVNWCManager.ensureAdminAreaExists(path, newURL.toString(), rootURL != null ? rootURL.toString() : null, uuid, 0L, depth == null ? SVNDepth.INFINITY : depth);
            } else {
                SVNURL rootURL = parentEntry.getRepositoryRootURL();
                SVNWCManager.ensureAdminAreaExists(path, copyFromURL.toString(), rootURL != null ? rootURL.toString() : null, parentEntry.getUUID(), copyFromRev, depth == null ? SVNDepth.INFINITY : depth);
            }
            if (entry == null || entry.isDeleted()) {
                dir = wcAccess.open(path, true, copyFromURL != null ? -1 : 0);
            }
            command.put("svn:entry:incomplete", null);
            command.put("svn:entry:schedule", replace ? "replace" : "add");
            dir.modifyEntry(dir.getThisDirName(), command, true, true);
            if (copyFromURL != null) {
                SVNURL newURL = parentEntry.getSVNURL().appendPath(name, false);
                SVNWCManager.updateCleanup(path, wcAccess, newURL.toString(), parentEntry.getRepositoryRoot(), -1L, false, null, SVNDepth.INFINITY, false);
                SVNWCManager.markTree(dir, null, true, false, 6);
                SVNPropertiesManager.deleteWCProperties(dir, null, true);
            }
        }
        SVNEvent event = SVNEventFactory.createSVNEvent(parentDir.getFile(name), kind, null, 0L, SVNEventAction.ADD, null, null, null);
        parentDir.getWCAccess().handleEvent(event);
    }

    public static void markEntry(SVNAdminArea dir, SVNEntry entry, String schedule, boolean copied, boolean keepLocal, int flags) throws SVNException {
        if (dir.getThisDirName().equals(entry.getName())) {
            return;
        }
        SVNHashMap attributes = new SVNHashMap();
        File path = dir.getFile(entry.getName());
        if (entry.getKind() == SVNNodeKind.DIR) {
            SVNAdminArea childDir = dir.getWCAccess().retrieve(path);
            SVNWCManager.markTree(childDir, schedule, copied, keepLocal, flags);
        }
        if ((flags & 1) != 0) {
            attributes.put("svn:entry:schedule", schedule);
        }
        if ((flags & 2) != 0) {
            attributes.put("svn:entry:copied", copied ? Boolean.TRUE.toString() : null);
        }
        dir.modifyEntry(entry.getName(), attributes, true, false);
        if (copied) {
            SVNPropertiesManager.deleteWCProperties(dir, entry.getName(), false);
        }
        if ("delete".equals(schedule)) {
            SVNEvent event = SVNEventFactory.createSVNEvent(path, SVNNodeKind.UNKNOWN, null, 0L, SVNEventAction.DELETE, null, null, null);
            dir.getWCAccess().handleEvent(event);
        }
    }

    public static void markTree(SVNAdminArea dir, String schedule, boolean copied, boolean keepLocal, int flags) throws SVNException {
        Iterator entries = dir.entries(false);
        while (entries.hasNext()) {
            SVNEntry entry = (SVNEntry)entries.next();
            SVNWCManager.markEntry(dir, entry, schedule, copied, keepLocal, flags);
        }
        SVNHashMap attributes = new SVNHashMap();
        SVNEntry dirEntry = dir.getEntry(dir.getThisDirName(), false);
        if (!dirEntry.isScheduledForAddition() || !"delete".equals(schedule)) {
            if ((flags & 1) != 0) {
                attributes.put("svn:entry:schedule", schedule);
            }
            if ((flags & 2) != 0) {
                attributes.put("svn:entry:copied", copied ? Boolean.TRUE.toString() : null);
            }
        }
        if ((flags & 4) != 0 && keepLocal) {
            attributes.put("svn:entry:keep-local", SVNProperty.toString(true));
        }
        if (attributes.size() > 0) {
            dir.modifyEntry(dir.getThisDirName(), attributes, true, false);
            attributes.clear();
        }
        dir.saveEntries(false);
    }

    public static void markTreeCancellable(SVNAdminArea dir, String schedule, boolean copied, boolean keepLocal, int flags) throws SVNException {
        SVNAdminArea childDir;
        SVNHashMap attributes = new SVNHashMap();
        SVNHashMap recurseMap = new SVNHashMap();
        Iterator entries = dir.entries(false);
        while (entries.hasNext()) {
            SVNEntry entry = (SVNEntry)entries.next();
            if (dir.getThisDirName().equals(entry.getName())) continue;
            File path = dir.getFile(entry.getName());
            if (entry.getKind() == SVNNodeKind.DIR) {
                childDir = dir.getWCAccess().retrieve(path);
                recurseMap.put(entry.getName(), childDir);
                continue;
            }
            if ((flags & 1) != 0) {
                attributes.put("svn:entry:schedule", schedule);
            }
            if ((flags & 2) != 0) {
                attributes.put("svn:entry:copied", copied ? Boolean.TRUE.toString() : null);
            }
            dir.modifyEntry(entry.getName(), attributes, true, false);
            attributes.clear();
            if (!"delete".equals(schedule)) continue;
            SVNEvent event = SVNEventFactory.createSVNEvent(dir.getFile(entry.getName()), SVNNodeKind.UNKNOWN, null, 0L, SVNEventAction.DELETE, null, null, null);
            dir.getWCAccess().handleEvent(event);
        }
        SVNEntry dirEntry = dir.getEntry(dir.getThisDirName(), false);
        if (!dirEntry.isScheduledForAddition() || !"delete".equals(schedule)) {
            if ((flags & 1) != 0) {
                attributes.put("svn:entry:schedule", schedule);
            }
            if ((flags & 2) != 0) {
                attributes.put("svn:entry:copied", copied ? Boolean.TRUE.toString() : null);
            }
            if (keepLocal) {
                attributes.put("svn:entry:keep-local", SVNProperty.toString(true));
            }
            dir.modifyEntry(dir.getThisDirName(), attributes, true, false);
            attributes.clear();
        }
        dir.saveEntries(false);
        dir.getWCAccess().checkCancelled();
        Iterator dirs = recurseMap.keySet().iterator();
        while (dirs.hasNext()) {
            String entryName = (String)dirs.next();
            childDir = (SVNAdminArea)recurseMap.get(entryName);
            if ((flags & 1) != 0) {
                attributes.put("svn:entry:schedule", schedule);
            }
            if ((flags & 2) != 0) {
                attributes.put("svn:entry:copied", copied ? Boolean.TRUE.toString() : null);
            }
            dir.modifyEntry(entryName, attributes, true, false);
            attributes.clear();
            if ("delete".equals(schedule)) {
                SVNEvent event = SVNEventFactory.createSVNEvent(dir.getFile(entryName), SVNNodeKind.UNKNOWN, null, 0L, SVNEventAction.DELETE, null, null, null);
                dir.getWCAccess().handleEvent(event);
            }
            dir.saveEntries(false);
            SVNWCManager.markTree(childDir, schedule, copied, keepLocal, flags);
        }
    }

    public static void updateCleanup(File path, SVNWCAccess wcAccess, String baseURL, String rootURL, long newRevision, boolean removeMissingDirs, Collection excludePaths, SVNDepth depth, boolean skipUnlocked) throws SVNException {
        SVNEntry entry = wcAccess.getEntry(path, true);
        if (entry == null) {
            return;
        }
        Collection collection = excludePaths = excludePaths == null ? Collections.EMPTY_LIST : excludePaths;
        if (entry.isFile() || entry.isDirectory() && (entry.isAbsent() || entry.isDeleted() || entry.getDepth() == SVNDepth.EXCLUDE)) {
            if (excludePaths.contains(path)) {
                return;
            }
            SVNAdminArea dir = wcAccess.retrieve(path.getParentFile());
            if (skipUnlocked && !dir.isLocked()) {
                return;
            }
            if (dir.tweakEntry(path.getName(), baseURL, rootURL, newRevision, false)) {
                dir.saveEntries(false);
            }
        } else if (entry.isDirectory()) {
            SVNAdminArea dir = wcAccess.retrieve(path);
            if (skipUnlocked && !dir.isLocked()) {
                return;
            }
            SVNWCManager.tweakEntries(dir, baseURL, rootURL, newRevision, removeMissingDirs, excludePaths, depth, skipUnlocked);
        } else {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.NODE_UNKNOWN_KIND, "Unrecognized node kind: ''{0}''", path);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
    }

    private static void tweakEntries(SVNAdminArea dir, String baseURL, String rootURL, long newRevision, boolean removeMissingDirs, Collection excludePaths, SVNDepth depth, boolean skipUnlocked) throws SVNException {
        if (excludePaths.contains(dir.getRoot())) {
            return;
        }
        boolean write = false;
        write = dir.tweakEntry(dir.getThisDirName(), baseURL, rootURL, newRevision, false);
        if (depth == SVNDepth.UNKNOWN) {
            depth = SVNDepth.INFINITY;
        }
        if (depth.compareTo(SVNDepth.EMPTY) > 0) {
            Iterator entries = dir.entries(true);
            while (entries.hasNext()) {
                SVNEntry entry = (SVNEntry)entries.next();
                if (dir.getThisDirName().equals(entry.getName())) continue;
                File childFile = dir.getFile(entry.getName());
                boolean isExcluded = excludePaths.contains(childFile);
                String childURL = null;
                if (baseURL != null) {
                    childURL = SVNPathUtil.append(baseURL, SVNEncodingUtil.uriEncode(entry.getName()));
                }
                if (entry.isFile() || entry.isAbsent() || entry.isDeleted() || entry.getDepth() == SVNDepth.EXCLUDE) {
                    if (isExcluded) continue;
                    write |= dir.tweakEntry(entry.getName(), childURL, rootURL, newRevision, true);
                    continue;
                }
                if (!entry.isDirectory() || depth != SVNDepth.INFINITY && depth != SVNDepth.IMMEDIATES) continue;
                SVNDepth depthBelowHere = depth == SVNDepth.IMMEDIATES ? SVNDepth.EMPTY : depth;
                File path = dir.getFile(entry.getName());
                if (removeMissingDirs && dir.getWCAccess().isMissing(path)) {
                    if (entry.isScheduledForAddition() || isExcluded) continue;
                    dir.deleteEntry(entry.getName());
                    dir.getWCAccess().handleEvent(SVNEventFactory.createSVNEvent(dir.getFile(entry.getName()), entry.getKind(), null, entry.getRevision(), SVNEventAction.UPDATE_DELETE, null, null, null));
                    continue;
                }
                SVNAdminArea childDir = dir.getWCAccess().retrieve(path);
                if (skipUnlocked && !childDir.isLocked()) continue;
                SVNWCManager.tweakEntries(childDir, childURL, rootURL, newRevision, removeMissingDirs, excludePaths, depthBelowHere, skipUnlocked);
            }
        }
        if (write) {
            dir.saveEntries(false);
        }
    }

    public static boolean ensureAdminAreaExists(File path, String url, String rootURL, String uuid, long revision, SVNDepth depth) throws SVNException {
        SVNFileType fileType = SVNFileType.getType(path);
        if (fileType != SVNFileType.DIRECTORY && fileType != SVNFileType.NONE) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "''{0}'' is not a directory", path);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (fileType == SVNFileType.NONE) {
            SVNAdminAreaFactory.createVersionedDirectory(path, url, rootURL, uuid, revision, depth);
            return true;
        }
        SVNWCAccess wcAccess = SVNWCAccess.newInstance(null);
        try {
            wcAccess.open(path, false, 0);
            SVNEntry entry = wcAccess.getVersionedEntry(path, false);
            if (!entry.isScheduledForDeletion()) {
                SVNErrorMessage err;
                if (entry.getRevision() != revision) {
                    err = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "Revision {0} doesn''t match existing revision {1} in ''{2}''", new Object[]{new Long(revision), new Long(entry.getRevision()), path});
                    SVNErrorManager.error(err, SVNLogType.WC);
                }
                if (!entry.getURL().equals(url)) {
                    err = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "URL {0} doesn''t match existing URL {1} in ''{2}''", new Object[]{url, entry.getURL(), path});
                    SVNErrorManager.error(err, SVNLogType.WC);
                }
            }
        }
        catch (SVNException e) {
            if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_DIRECTORY) {
                SVNAdminAreaFactory.createVersionedDirectory(path, url, rootURL, uuid, revision, depth);
                boolean bl = true;
                return bl;
            }
            throw e;
        }
        finally {
            wcAccess.close();
        }
        return false;
    }

    public static void canDelete(File path, ISVNOptions options, final ISVNEventHandler eventHandler) throws SVNException {
        SVNStatusClient statusClient = new SVNStatusClient((ISVNAuthenticationManager)null, options);
        if (eventHandler != null) {
            statusClient.setEventHandler(new ISVNEventHandler(){

                public void checkCancelled() throws SVNCancelException {
                    eventHandler.checkCancelled();
                }

                public void handleEvent(SVNEvent event, double progress) throws SVNException {
                }
            });
        }
        statusClient.doStatus(path, SVNRevision.UNDEFINED, SVNDepth.INFINITY, false, false, false, false, new ISVNStatusHandler(){

            public void handleStatus(SVNStatus status) throws SVNException {
                if (status.getContentsStatus() == SVNStatusType.STATUS_OBSTRUCTED) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.NODE_UNEXPECTED_KIND, "''{0}'' is in the way of the resource actually under version control", status.getFile());
                    SVNErrorManager.error(err, SVNLogType.WC);
                } else if (status.getEntry() == null) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNVERSIONED_RESOURCE, "''{0}'' is not under version control", status.getFile());
                    SVNErrorManager.error(err, SVNLogType.WC);
                } else if (status.getContentsStatus() != SVNStatusType.STATUS_NORMAL && status.getContentsStatus() != SVNStatusType.STATUS_DELETED && status.getContentsStatus() != SVNStatusType.STATUS_MISSING || status.getPropertiesStatus() != SVNStatusType.STATUS_NONE && status.getPropertiesStatus() != SVNStatusType.STATUS_NORMAL) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_MODIFIED, "''{0}'' has local modifications", status.getFile());
                    SVNErrorManager.error(err, SVNLogType.WC);
                }
            }
        }, null);
    }

    public static void delete(SVNWCAccess wcAccess, SVNAdminArea root, File path, boolean deleteFiles, boolean cancellable) throws SVNException {
        SVNAdminArea dir = wcAccess.probeTry(path, true, -1);
        SVNEntry entry = null;
        if (dir == null) {
            SVNWCManager.doDeleteUnversionedFiles(wcAccess, path, deleteFiles);
            return;
        }
        entry = wcAccess.getEntry(path, false);
        if (entry == null) {
            SVNWCManager.doDeleteUnversionedFiles(wcAccess, path, deleteFiles);
            return;
        }
        if (entry.getExternalFilePath() != null) {
            String externalProperty = dir.getProperties(dir.getThisDirName()).getStringPropertyValue("svn:externals");
            String name = entry.getName();
            if (externalProperty != null) {
                SVNExternal[] externals = SVNExternal.parseExternals("", externalProperty);
                for (int i = 0; i < externals.length; ++i) {
                    if (!name.equals(externals[i].getPath())) continue;
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_CANNOT_DELETE_FILE_EXTERNAL, "Cannot remove the file external at ''{0}''; please propedit or propdel the svn:externals description that created it", path);
                    SVNErrorManager.error(err, SVNLogType.WC);
                }
            }
            dir.removeFromRevisionControl(name, deleteFiles, false);
            SVNEvent event = SVNEventFactory.createSVNEvent(path, SVNNodeKind.UNKNOWN, null, 0L, SVNEventAction.DELETE, null, null, null);
            wcAccess.handleEvent(event);
            return;
        }
        String schedule = entry.getSchedule();
        SVNNodeKind kind = entry.getKind();
        boolean copied = entry.isCopied();
        boolean deleted = false;
        String name = path.getName();
        if (kind == SVNNodeKind.DIR) {
            SVNAdminArea parent = wcAccess.retrieve(path.getParentFile());
            SVNEntry entryInParent = parent.getEntry(name, true);
            boolean bl = deleted = entryInParent != null ? entryInParent.isDeleted() : false;
            if (!deleted && "add".equals(schedule)) {
                if (dir != root) {
                    dir.removeFromRevisionControl("", false, false);
                } else {
                    parent.deleteEntry(name);
                    parent.saveEntries(false);
                }
            } else if (dir != root) {
                if (cancellable) {
                    SVNWCManager.markTreeCancellable(dir, "delete", false, !deleteFiles, 1);
                } else {
                    SVNWCManager.markTree(dir, "delete", false, !deleteFiles, 5);
                }
            }
        }
        if (kind != SVNNodeKind.DIR || !"add".equals(schedule) || deleted) {
            SVNLog log = root.getLog();
            SVNProperties command = new SVNProperties();
            command.put("name", name);
            command.put(SVNProperty.shortPropertyName("svn:entry:schedule"), "delete");
            log.addCommand("modify-entry", command, false);
            command.clear();
            if ("replace".equals(schedule) && copied) {
                if (kind != SVNNodeKind.DIR) {
                    command.put("name", SVNAdminUtil.getTextRevertPath(name, false));
                    command.put("dest", SVNAdminUtil.getTextBasePath(name, false));
                    log.addCommand("mv", command, false);
                    command.clear();
                }
                command.put("name", SVNAdminUtil.getPropRevertPath(name, kind, false));
                command.put("dest", SVNAdminUtil.getPropBasePath(name, kind, false));
                log.addCommand("mv", command, false);
                command.clear();
            }
            if ("add".equals(schedule)) {
                command.put("name", SVNAdminUtil.getPropPath(name, kind, false));
                log.addCommand("rm", command, false);
                command.clear();
                command.put("name", SVNAdminUtil.getPropBasePath(name, kind, false));
                log.addCommand("rm", command, false);
                command.clear();
                command.put("name", SVNAdminUtil.getTextBasePath(name, false));
                log.addCommand("rm", command, false);
                command.clear();
            }
            log.save();
            root.runLogs();
        }
        SVNEvent event = SVNEventFactory.createSVNEvent(root.getFile(name), SVNNodeKind.UNKNOWN, null, 0L, SVNEventAction.DELETE, null, null, null);
        wcAccess.handleEvent(event);
        if ("add".equals(schedule)) {
            SVNWCManager.doDeleteUnversionedFiles(wcAccess, path, deleteFiles);
        } else {
            SVNWCManager.doEraseFromWC(path, root, kind, deleteFiles);
        }
    }

    public static void doDeleteUnversionedFiles(SVNWCAccess wcAccess, File path, boolean deleteFiles) throws SVNException {
        wcAccess.checkCancelled();
        SVNFileType fileType = SVNFileType.getType(path);
        if (fileType == SVNFileType.NONE) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.BAD_FILENAME, "''{0}'' does not exist", path);
            SVNErrorManager.error(err, SVNLogType.WC);
        } else if (fileType != SVNFileType.FILE && fileType != SVNFileType.DIRECTORY && fileType != SVNFileType.SYMLINK) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Unsupported node kind for path ''{0}''", path);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (deleteFiles) {
            SVNFileUtil.deleteAll(path, true, wcAccess.getEventHandler());
        }
    }

    public static void doEraseFromWC(File path, SVNAdminArea dir, SVNNodeKind kind, boolean deleteFiles) throws SVNException {
        SVNFileType type = SVNFileType.getType(path);
        if (type == SVNFileType.NONE) {
            return;
        }
        dir.getWCAccess().checkCancelled();
        if (kind == SVNNodeKind.FILE) {
            if (deleteFiles) {
                SVNFileUtil.deleteFile(path);
            }
        } else if (kind == SVNNodeKind.DIR) {
            SVNAdminArea childDir = null;
            try {
                childDir = dir.getWCAccess().retrieve(path);
            }
            catch (SVNException svne) {
                if (!path.exists()) {
                    return;
                }
                throw svne;
            }
            SVNHashSet versioned = new SVNHashSet();
            Iterator entries = childDir.entries(false);
            while (entries.hasNext()) {
                SVNEntry entry = (SVNEntry)entries.next();
                versioned.add(entry.getName());
                if (childDir.getThisDirName().equals(entry.getName())) continue;
                File childPath = childDir.getFile(entry.getName());
                SVNWCManager.doEraseFromWC(childPath, childDir, entry.getKind(), deleteFiles);
            }
            File[] children = SVNFileListUtil.listFiles(path);
            for (int i = 0; children != null && i < children.length; ++i) {
                if (SVNFileUtil.getAdminDirectoryName().equals(children[i].getName()) || versioned.contains(children[i].getName())) continue;
                SVNWCManager.doDeleteUnversionedFiles(dir.getWCAccess(), children[i], deleteFiles);
            }
        }
    }

    public static void addRepositoryFile(SVNAdminArea dir, String fileName, File text, File textBase, SVNProperties baseProperties, SVNProperties properties, String copyFromURL, long copyFromRev) throws SVNException {
        SVNEntry parentEntry = dir.getVersionedEntry(dir.getThisDirName(), false);
        String newURL = SVNPathUtil.append(parentEntry.getURL(), SVNEncodingUtil.uriEncode(fileName));
        if (copyFromURL != null && parentEntry.getRepositoryRoot() != null && !SVNPathUtil.isAncestor(parentEntry.getRepositoryRoot(), copyFromURL)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Copyfrom-url ''{0}'' has different repository root than ''{1}''", new Object[]{copyFromURL, parentEntry.getRepositoryRoot()});
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        SVNEntry dstEntry = dir.getEntry(fileName, false);
        SVNLog log = dir.getLog();
        SVNProperties command = new SVNProperties();
        if (dstEntry != null && dstEntry.isScheduledForDeletion()) {
            String revertTextPath = SVNAdminUtil.getTextRevertPath(fileName, false);
            String baseTextPath = SVNAdminUtil.getTextBasePath(fileName, false);
            String revertPropsPath = SVNAdminUtil.getPropRevertPath(fileName, SVNNodeKind.FILE, false);
            String basePropsPath = SVNAdminUtil.getPropBasePath(fileName, SVNNodeKind.FILE, false);
            command.put("name", baseTextPath);
            command.put("dest", revertTextPath);
            log.addCommand("mv", command, false);
            command.clear();
            if (dir.getFile(basePropsPath).isFile()) {
                command.put("name", basePropsPath);
                command.put("dest", revertPropsPath);
                log.addCommand("mv", command, false);
                command.clear();
            } else {
                String emptyPropPath = SVNAdminUtil.getPropBasePath(fileName, SVNNodeKind.FILE, false);
                SVNWCProperties.setProperties(new SVNProperties(), null, dir.getFile(emptyPropPath), "END");
                command.put("name", emptyPropPath);
                command.put("dest", revertPropsPath);
                log.addCommand("mv", command, false);
                command.clear();
            }
        }
        SVNProperties entryAttrs = new SVNProperties();
        entryAttrs.put(SVNProperty.shortPropertyName("svn:entry:schedule"), "add");
        if (copyFromURL != null) {
            entryAttrs.put(SVNProperty.shortPropertyName("svn:entry:copied"), SVNProperty.toString(true));
            entryAttrs.put(SVNProperty.shortPropertyName("svn:entry:copyfrom-url"), copyFromURL);
            entryAttrs.put(SVNProperty.shortPropertyName("svn:entry:copyfrom-rev"), SVNProperty.toString(copyFromRev));
        }
        log.logChangedEntryProperties(fileName, entryAttrs);
        entryAttrs.clear();
        log.logTweakEntry(fileName, newURL, dstEntry != null ? dstEntry.getRevision() : parentEntry.getRevision());
        SVNWCManager.addProperties(dir, fileName, baseProperties, true, log);
        SVNWCManager.addProperties(dir, fileName, properties, false, log);
        File tmpTextBase = dir.getBaseFile(fileName, true);
        if (!tmpTextBase.equals(textBase) && textBase != null) {
            SVNFileUtil.rename(textBase, tmpTextBase);
        }
        if (text != null) {
            File tmpFile = SVNFileUtil.createUniqueFile(dir.getRoot(), fileName, ".tmp", false);
            SVNFileUtil.rename(text, tmpFile);
            if (baseProperties != null && baseProperties.containsName("svn:special")) {
                command.put("name", tmpFile.getName());
                command.put("dest", fileName);
                command.put("arg1", "true");
                log.addCommand("cp", command, false);
                command.clear();
                command.put("name", tmpFile.getName());
                log.addCommand("rm", command, false);
                command.clear();
            } else {
                command.put("name", tmpFile.getName());
                command.put("dest", fileName);
                log.addCommand("mv", command, false);
                command.clear();
            }
        } else {
            command.put("name", SVNAdminUtil.getTextBasePath(fileName, true));
            command.put("dest", fileName);
            log.addCommand("cp-and-translate", command, false);
            command.clear();
            command.put(SVNProperty.shortPropertyName("svn:entry:text-time"), "working");
            command.put(SVNProperty.shortPropertyName("svn:entry:working-size"), "working");
            log.logChangedEntryProperties(fileName, command);
            command.clear();
        }
        command.put("name", SVNAdminUtil.getTextBasePath(fileName, true));
        command.put("dest", SVNAdminUtil.getTextBasePath(fileName, false));
        log.addCommand("mv", command, false);
        command.clear();
        command.put("name", SVNAdminUtil.getTextBasePath(fileName, false));
        log.addCommand("readonly", command, false);
        command.clear();
        String checksum = SVNFileUtil.computeChecksum(dir.getBaseFile(fileName, true));
        entryAttrs.put(SVNProperty.shortPropertyName("svn:entry:checksum"), checksum);
        log.logChangedEntryProperties(fileName, entryAttrs);
        entryAttrs.clear();
        log.save();
        dir.runLogs();
    }

    public static void addProperties(SVNAdminArea dir, String fileName, SVNProperties properties, boolean base, SVNLog log) throws SVNException {
        if (properties == null || properties.isEmpty()) {
            return;
        }
        SVNProperties regularProps = new SVNProperties();
        SVNProperties entryProps = new SVNProperties();
        SVNProperties wcProps = new SVNProperties();
        Iterator names = properties.nameSet().iterator();
        while (names.hasNext()) {
            String propName = (String)names.next();
            SVNPropertyValue propValue = properties.getSVNPropertyValue(propName);
            if (SVNProperty.isEntryProperty(propName)) {
                entryProps.put(SVNProperty.shortPropertyName(propName), propValue);
                continue;
            }
            if (SVNProperty.isWorkingCopyProperty(propName)) {
                wcProps.put(propName, propValue);
                continue;
            }
            regularProps.put(propName, propValue);
        }
        SVNVersionedProperties props = base ? dir.getBaseProperties(fileName) : dir.getProperties(fileName);
        props.removeAll();
        Iterator propNames = regularProps.nameSet().iterator();
        while (propNames.hasNext()) {
            String propName = (String)propNames.next();
            SVNPropertyValue propValue = regularProps.getSVNPropertyValue(propName);
            props.setPropertyValue(propName, propValue);
        }
        dir.saveVersionedProperties(log, false);
        log.logChangedEntryProperties(fileName, entryProps);
        log.logChangedWCProperties(fileName, wcProps);
    }

    public static boolean isEntrySwitched(File path, SVNEntry entry) throws SVNException {
        SVNURL expectedSVNURL;
        File parent = (path = new File(SVNPathUtil.validateFilePath(path.getAbsolutePath())).getAbsoluteFile()).getParentFile();
        if (parent == null) {
            return false;
        }
        SVNWCAccess access = SVNWCAccess.newInstance(null);
        SVNAdminArea parentAdminArea = null;
        SVNEntry parentEntry = null;
        try {
            parentAdminArea = access.open(parent, false, 0);
            parentEntry = parentAdminArea.getVersionedEntry(parentAdminArea.getThisDirName(), false);
        }
        catch (SVNException svne) {
            if (svne.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_DIRECTORY) {
                boolean bl = false;
                return bl;
            }
            throw svne;
        }
        finally {
            access.close();
        }
        SVNURL parentSVNURL = parentEntry.getSVNURL();
        SVNURL entrySVNURL = entry.getSVNURL();
        if (parentSVNURL == null || entrySVNURL == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "Cannot find a URL for ''{0}''", parentSVNURL == null ? parent : path);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        return !entrySVNURL.equals(expectedSVNURL = parentSVNURL.appendPath(path.getName(), false));
    }

    public static void crop(SVNAdminAreaInfo info, SVNDepth depth) throws SVNException {
        SVNErrorMessage err;
        SVNEntry targetEntry;
        if (depth == SVNDepth.INFINITY) {
            return;
        }
        if (depth.compareTo(SVNDepth.EXCLUDE) < 0 || depth.compareTo(SVNDepth.INFINITY) >= 0) {
            SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Can only crop a working copy with a restrictive depth");
            SVNErrorManager.error(err2, SVNLogType.WC);
        }
        SVNWCAccess wcAccess = info.getWCAccess();
        File fullPath = info.getAnchor().getRoot();
        if (!"".equals(info.getTargetName())) {
            fullPath = new File(fullPath, info.getTargetName());
        }
        if ((targetEntry = wcAccess.getEntry(fullPath, false)) == null || !targetEntry.isDirectory()) {
            err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Can only crop directories");
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (targetEntry.isScheduledForDeletion()) {
            err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Cannot crop ''{0}'': it is going to be removed from repository. Try commit instead", fullPath);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (depth == SVNDepth.EXCLUDE) {
            boolean inRepos;
            SVNURL expectedURL;
            if (fullPath.getParentFile() == null) {
                err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Cannot exclude root directory");
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            SVNAdminArea parentDir = wcAccess.getAdminArea(fullPath.getParentFile());
            SVNEntry parentEntry = null;
            if (parentDir == null) {
                try {
                    parentDir = wcAccess.probeOpen(fullPath.getParentFile(), false, 0);
                }
                catch (SVNException e) {
                    // empty catch block
                }
            }
            if (parentDir != null) {
                parentEntry = wcAccess.getEntry(fullPath.getParentFile(), false);
            }
            if (parentEntry != null && !(expectedURL = parentEntry.getSVNURL().appendPath(fullPath.getName(), false)).equals(targetEntry.getSVNURL())) {
                SVNErrorMessage err3 = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Cannot crop ''{0}'': it is a switched path", fullPath);
                SVNErrorManager.error(err3, SVNLogType.WC);
            }
            boolean bl = inRepos = !targetEntry.isScheduledForAddition() && !targetEntry.isScheduledForReplacement() || targetEntry.isCopied();
            if (parentEntry != null && inRepos && parentEntry.getDepth().compareTo(SVNDepth.FILES) > 0) {
                SVNEntry entryInParent = parentDir.getEntry(fullPath.getName(), false);
                entryInParent.setDepth(SVNDepth.EXCLUDE);
                parentDir.saveEntries(true);
            }
            SVNAdminArea dir = wcAccess.retrieve(fullPath);
            try {
                dir.removeFromRevisionControl(dir.getThisDirName(), true, false);
            }
            catch (SVNException svne) {
                SVNWCManager.handleLeftLocalModificationsError(svne);
            }
            SVNEvent event = SVNEventFactory.createSVNEvent(fullPath, SVNNodeKind.DIR, null, -1L, SVNEventAction.UPDATE_DELETE, null, null, null);
            wcAccess.handleEvent(event);
            return;
        }
        SVNWCManager.cropChildren(wcAccess, fullPath, depth);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getActualTarget(File file) throws SVNException {
        SVNWCAccess wcAccess = SVNWCAccess.newInstance(null);
        try {
            SVNNodeKind kind;
            wcAccess.probeOpen(file, false, 0);
            boolean isWCRoot = wcAccess.isWCRoot(file);
            SVNEntry entry = wcAccess.getEntry(file, false);
            SVNNodeKind sVNNodeKind = kind = entry != null ? entry.getKind() : SVNNodeKind.FILE;
            if (kind == SVNNodeKind.FILE || !isWCRoot) {
                String string = file.getName();
                return string;
            }
        }
        finally {
            wcAccess.close();
        }
        return "";
    }

    public static void createRevertProperties(SVNWCAccess access, File path, boolean removeBase) throws SVNException {
        SVNEntry entry = access.getVersionedEntry(path, false);
        String revertPropPath = SVNAdminUtil.getPropRevertPath(entry.getName(), entry.getKind(), false);
        String basePropPath = SVNAdminUtil.getPropBasePath(entry.getName(), entry.getKind(), false);
        SVNAdminArea area = entry.getAdminArea();
        SVNLog log = area.getLog();
        File basePropFile = area.getFile(basePropPath);
        if (basePropFile.isFile()) {
            SVNProperties command = new SVNProperties();
            command.put("name", basePropPath);
            command.put("dest", revertPropPath);
            if (removeBase) {
                log.addCommand("mv", command, false);
            } else {
                log.addCommand("cp", command, false);
            }
        } else {
            String tmpPath = SVNAdminUtil.getPropRevertPath(entry.getName(), entry.getKind(), true);
            File tmpFile = area.getFile(tmpPath);
            SVNWCProperties.setProperties(new SVNProperties(), tmpFile, null, "END");
            SVNProperties command = new SVNProperties();
            command.put("name", tmpPath);
            command.put("dest", revertPropPath);
            log.addCommand("mv", command, false);
        }
        log.save();
        area.runLogs();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void cropChildren(SVNWCAccess wcAccess, File path, SVNDepth depth) throws SVNException {
        SVNAdminArea dir = wcAccess.retrieve(path);
        SVNEntry dotEntry = dir.getEntry(dir.getThisDirName(), false);
        if (dotEntry.getDepth().compareTo(depth) > 0) {
            dotEntry.setDepth(depth);
            dir.saveEntries(false);
        }
        Iterator ents = dir.entries(true);
        while (true) {
            File entryPath;
            SVNEntry entry;
            block13: {
                if (!ents.hasNext()) {
                    return;
                }
                entry = (SVNEntry)ents.next();
                if (entry.isThisDir()) continue;
                entryPath = new File(path, entry.getName());
                if (entry.isFile()) {
                    if (depth != SVNDepth.EMPTY) continue;
                    try {
                        dir.removeFromRevisionControl(entry.getName(), true, false);
                    }
                    catch (SVNException e) {
                        SVNWCManager.handleLeftLocalModificationsError(e);
                    }
                } else {
                    if (entry.isDirectory()) {
                        if (entry.getDepth() == SVNDepth.EXCLUDE) {
                            if (depth.compareTo(SVNDepth.IMMEDIATES) >= 0) continue;
                            dir.deleteEntry(entry.getName());
                            dir.saveEntries(false);
                            continue;
                        }
                        if (depth.compareTo(SVNDepth.IMMEDIATES) < 0) {
                            SVNAdminArea childDir = wcAccess.retrieve(entryPath);
                            try {
                                childDir.removeFromRevisionControl(childDir.getThisDirName(), true, false);
                            }
                            catch (SVNException e) {
                                SVNWCManager.handleLeftLocalModificationsError(e);
                            }
                            break block13;
                        } else {
                            SVNWCManager.cropChildren(wcAccess, entryPath, SVNDepth.EMPTY);
                            continue;
                        }
                    }
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.NODE_UNKNOWN_KIND, "Unknown entry kind for ''{0}''", entryPath);
                    SVNErrorManager.error(err, SVNLogType.WC);
                }
            }
            SVNEvent event = SVNEventFactory.createSVNEvent(entryPath, entry.getKind(), null, -1L, SVNEventAction.UPDATE_DELETE, null, null, null);
            wcAccess.handleEvent(event);
        }
    }

    private static void handleLeftLocalModificationsError(SVNException originalError) throws SVNException {
        SVNException error = null;
        error = originalError;
        while (error != null && error.getErrorMessage().getErrorCode() != SVNErrorCode.WC_LEFT_LOCAL_MOD) {
            error = error.getCause() instanceof SVNException ? (SVNException)error.getCause() : null;
        }
        if (error != null) {
            return;
        }
        throw originalError;
    }
}

