/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Map;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;

public class SVNConfigFile {
    private File myFile;
    private String[] myLines;
    private long myLastModified;
    static /* synthetic */ Class class$org$tmatesoft$svn$core$internal$wc$SVNConfigFile;

    public SVNConfigFile(File file) {
        this.myFile = file.getAbsoluteFile();
    }

    protected String[] getLines() {
        return this.myLines;
    }

    public Map getProperties(String groupName) {
        SVNHashMap map = new SVNHashMap();
        this.load();
        boolean groupMatched = false;
        for (int i = 0; i < this.myLines.length; ++i) {
            String line = this.myLines[i];
            if (line == null) continue;
            if (!groupMatched && SVNConfigFile.matchGroup(line, groupName)) {
                groupMatched = true;
                continue;
            }
            if (!groupMatched) continue;
            if (SVNConfigFile.matchGroup(line, null)) {
                return map;
            }
            if (!SVNConfigFile.matchProperty(line, null)) continue;
            map.put(SVNConfigFile.getPropertyName(line), SVNConfigFile.getPropertyValue(line));
        }
        return map;
    }

    public String getPropertyValue(String groupName, String propertyName) {
        this.load();
        boolean groupMatched = false;
        for (int i = 0; i < this.myLines.length; ++i) {
            String line = this.myLines[i];
            if (line == null) continue;
            if (!groupMatched && SVNConfigFile.matchGroup(line, groupName)) {
                groupMatched = true;
                continue;
            }
            if (!groupMatched) continue;
            if (SVNConfigFile.matchGroup(line, null)) {
                return null;
            }
            if (!SVNConfigFile.matchProperty(line, propertyName)) continue;
            return SVNConfigFile.getPropertyValue(line);
        }
        return null;
    }

    public void setPropertyValue(String groupName, String propertyName, String propertyValue, boolean save) {
        this.load();
        boolean groupMatched = false;
        for (int i = 0; i < this.myLines.length; ++i) {
            String line = this.myLines[i];
            if (line == null) continue;
            if (!groupMatched && SVNConfigFile.matchGroup(line, groupName)) {
                groupMatched = true;
                continue;
            }
            if (!groupMatched) continue;
            if (SVNConfigFile.matchGroup(line, null)) {
                if (propertyValue != null) {
                    String[] lines = new String[this.myLines.length + 1];
                    System.arraycopy(this.myLines, 0, lines, 0, i);
                    System.arraycopy(this.myLines, i, lines, i + 1, this.myLines.length - i);
                    lines[i] = propertyName + "  = " + propertyValue;
                    this.myLines = lines;
                    if (save) {
                        this.save();
                    }
                }
                return;
            }
            if (!SVNConfigFile.matchProperty(line, propertyName)) continue;
            this.myLines[i] = propertyValue == null ? null : propertyName + " = " + propertyValue;
            if (save) {
                this.save();
            }
            return;
        }
        if (propertyValue != null) {
            String[] lines = new String[this.myLines.length + (groupMatched ? 1 : 2)];
            if (!groupMatched) {
                lines[lines.length - 2] = "[" + groupName + "]";
            }
            lines[lines.length - 1] = propertyName + "  = " + propertyValue;
            System.arraycopy(this.myLines, 0, lines, 0, this.myLines.length);
            this.myLines = lines;
            if (save) {
                this.save();
            }
        }
    }

    public void deleteGroup(String groupName, boolean save) {
        this.load();
        boolean groupMatched = false;
        for (int i = 0; i < this.myLines.length; ++i) {
            String line = this.myLines[i];
            if (line == null) continue;
            if (!groupMatched && SVNConfigFile.matchGroup(line, groupName)) {
                groupMatched = true;
                this.myLines[i] = null;
                continue;
            }
            if (!groupMatched) continue;
            if (SVNConfigFile.matchGroup(line, null)) break;
            this.myLines[i] = null;
        }
        if (save) {
            this.save();
        }
    }

    private static boolean matchGroup(String line, String name) {
        if ((line = line.trim()).startsWith("[") && line.endsWith("]")) {
            return name == null || line.substring(1, line.length() - 1).equals(name);
        }
        return false;
    }

    private static boolean matchProperty(String line, String name) {
        if ((line = line.trim()).startsWith("#")) {
            return false;
        }
        if (line.indexOf(61) < 0) {
            return false;
        }
        line = line.substring(0, line.indexOf(61));
        return name == null || line.trim().equals(name);
    }

    private static String getPropertyValue(String line) {
        if ((line = line.trim()).indexOf(61) < 0) {
            return null;
        }
        line = line.substring(line.indexOf(61) + 1);
        return line.trim();
    }

    private static String getPropertyName(String line) {
        if ((line = line.trim()).indexOf(61) < 0) {
            return null;
        }
        line = line.substring(0, line.indexOf(61));
        return line.trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void save() {
        if (this.myLines == null) {
            return;
        }
        if (this.myFile.isDirectory()) {
            return;
        }
        if (this.myFile.getParentFile() != null) {
            this.myFile.getParentFile().mkdirs();
        }
        FileWriter writer = null;
        String eol = System.getProperty("line.separator");
        eol = eol == null ? "\n" : eol;
        try {
            writer = new FileWriter(this.myFile);
            for (int i = 0; i < this.myLines.length; ++i) {
                String line = this.myLines[i];
                if (line == null) continue;
                writer.write(line);
                writer.write(eol);
            }
        }
        catch (IOException iOException) {
            SVNFileUtil.closeFile(writer);
            catch (Throwable throwable) {
                SVNFileUtil.closeFile(writer);
                throw throwable;
            }
        }
        SVNFileUtil.closeFile(writer);
        this.myLastModified = this.myFile.lastModified();
        this.myLines = this.doLoad(this.myFile);
    }

    private void load() {
        if (this.myLines != null && this.myFile.lastModified() == this.myLastModified) {
            return;
        }
        this.myLastModified = this.myFile.lastModified();
        this.myLines = this.doLoad(this.myFile);
        this.myLastModified = this.myFile.lastModified();
    }

    public boolean isModified() {
        if (this.myLines == null) {
            return false;
        }
        String[] lines = this.doLoad(this.myFile);
        if (lines.length != this.myLines.length) {
            return true;
        }
        for (int i = 0; i < this.myLines.length; ++i) {
            String line = this.myLines[i];
            if (line == null) {
                return true;
            }
            if (line.equals(lines[i])) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] doLoad(File file) {
        if (!file.isFile() || !file.canRead()) {
            return new String[0];
        }
        BufferedReader reader = null;
        ArrayList<String> lines = new ArrayList<String>();
        try {
            String line;
            reader = new BufferedReader(new FileReader(this.myFile));
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
            SVNFileUtil.closeFile(reader);
        }
        catch (IOException e) {
            lines.clear();
        }
        finally {
            SVNFileUtil.closeFile(reader);
        }
        return lines.toArray(new String[lines.size()]);
    }

    public static void createDefaultConfiguration(File configDir) {
        if (!configDir.isDirectory() && !configDir.mkdirs()) {
            return;
        }
        File configFile = new File(configDir, "config");
        File serversFile = new File(configDir, "servers");
        File readmeFile = new File(configDir, "README.txt");
        SVNConfigFile.writeFile("/org/tmatesoft/svn/core/internal/wc/config/config", configFile);
        SVNConfigFile.writeFile("/org/tmatesoft/svn/core/internal/wc/config/servers", serversFile);
        SVNConfigFile.writeFile("/org/tmatesoft/svn/core/internal/wc/config/README.txt", readmeFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void writeFile(String url, File configFile) {
        if (url == null || configFile == null || configFile.exists()) {
            return;
        }
        InputStream resource = (class$org$tmatesoft$svn$core$internal$wc$SVNConfigFile == null ? (class$org$tmatesoft$svn$core$internal$wc$SVNConfigFile = SVNConfigFile.class$("org.tmatesoft.svn.core.internal.wc.SVNConfigFile")) : class$org$tmatesoft$svn$core$internal$wc$SVNConfigFile).getResourceAsStream(url);
        if (resource == null) {
            return;
        }
        BufferedReader is = new BufferedReader(new InputStreamReader(resource));
        String eol = System.getProperty("line.separator", "\n");
        BufferedWriter os = null;
        try {
            String line;
            os = new BufferedWriter(new OutputStreamWriter(SVNFileUtil.openFileForWriting(configFile)));
            while ((line = is.readLine()) != null) {
                os.write(line);
                os.write(eol);
            }
        }
        catch (IOException e) {
            SVNFileUtil.closeFile(os);
            SVNFileUtil.closeFile(is);
        }
        catch (SVNException e2) {
            SVNFileUtil.closeFile(os);
            SVNFileUtil.closeFile(is);
            {
                catch (Throwable throwable) {
                    SVNFileUtil.closeFile(os);
                    SVNFileUtil.closeFile(is);
                    throw throwable;
                }
            }
        }
        SVNFileUtil.closeFile(os);
        SVNFileUtil.closeFile(is);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

