/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.generate.tostring.element;

import java.io.Serializable;
import java.util.Arrays;
import org.jetbrains.generate.tostring.util.StringUtil;

public class ClassElement
implements Serializable {
    private String name;
    private String qualifiedName;
    private boolean hasSuper;
    private String superName;
    private String superQualifiedName;
    private String[] implementNames;
    private boolean deprecated;
    private boolean _enum;
    private boolean exception;
    private boolean _abstract;

    public boolean isImplements(String interfaceName) {
        for (String className : this.implementNames) {
            if (interfaceName.indexOf(className) == -1) continue;
            return true;
        }
        return false;
    }

    public boolean isExtends(String classNames) {
        return classNames.indexOf(this.superName) != -1;
    }

    public boolean matchName(String regexp) throws IllegalArgumentException {
        if (StringUtil.isEmpty(regexp)) {
            throw new IllegalArgumentException("Can't perform regular expression since the given input is empty. Check your Velocity template: regexp='" + regexp + "'");
        }
        return this.name.matches(regexp);
    }

    public String[] getImplementNames() {
        return this.implementNames;
    }

    public void setImplementNames(String[] implementNames) {
        this.implementNames = implementNames;
    }

    public String getSuperQualifiedName() {
        return this.superQualifiedName;
    }

    public void setSuperQualifiedName(String superQualifiedName) {
        this.superQualifiedName = superQualifiedName;
    }

    public String getSuperName() {
        return this.superName;
    }

    public void setSuperName(String superName) {
        this.superName = superName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public void setQualifiedName(String FQClassname) {
        this.qualifiedName = FQClassname;
    }

    public boolean isHasSuper() {
        return this.hasSuper;
    }

    public void setHasSuper(boolean hasSuper) {
        this.hasSuper = hasSuper;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(boolean deprecated) {
        this.deprecated = deprecated;
    }

    public boolean isEnum() {
        return this._enum;
    }

    public void setEnum(boolean aEnum) {
        this._enum = aEnum;
    }

    public boolean isException() {
        return this.exception;
    }

    public void setException(boolean exception) {
        this.exception = exception;
    }

    public boolean isAbstract() {
        return this._abstract;
    }

    public void setAbstract(boolean aAbstract) {
        this._abstract = aAbstract;
    }

    public String toString() {
        return "ClassElement{name='" + this.name + "'" + ", qualifiedName='" + this.qualifiedName + "'" + ", hasSuper=" + this.hasSuper + ", superName='" + this.superName + "'" + ", superQualifiedName='" + this.superQualifiedName + "'" + ", implementNames=" + (this.implementNames == null ? null : Arrays.asList(this.implementNames)) + ", enum=" + this._enum + ", deprecated=" + this.deprecated + ", exception=" + this.exception + ", abstract=" + this._abstract + "}";
    }
}

