/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.validation;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.ant.AntBundle;
import com.intellij.lang.ant.psi.AntElement;
import com.intellij.lang.ant.psi.AntFile;
import com.intellij.lang.ant.psi.AntProject;
import com.intellij.lang.ant.psi.AntProperty;
import com.intellij.lang.ant.psi.AntStructuredElement;
import com.intellij.lang.ant.psi.AntTarget;
import com.intellij.lang.ant.psi.AntTask;
import com.intellij.lang.ant.psi.AntTypeDef;
import com.intellij.lang.ant.psi.impl.reference.AntPropertyReference;
import com.intellij.lang.ant.psi.impl.reference.AntReference;
import com.intellij.lang.ant.psi.introspection.AntAttributeType;
import com.intellij.lang.ant.psi.introspection.AntTypeDefinition;
import com.intellij.lang.ant.quickfix.AntCreateMacroDefFix;
import com.intellij.lang.ant.quickfix.AntCreatePresetDefFix;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import java.text.SimpleDateFormat;
import org.jetbrains.annotations.NonNls;

public class AntAnnotator
implements Annotator {
    public void annotate(PsiElement psiElement, AnnotationHolder holder) {
        if (!(psiElement instanceof AntElement)) {
            return;
        }
        AntElement element = (AntElement)psiElement;
        if (element instanceof AntStructuredElement) {
            AntElement parent;
            AntStructuredElement se = (AntStructuredElement)element;
            AntTypeDefinition def = se.getTypeDefinition();
            String name = se.getSourceElement().getName();
            TextRange absoluteRange = new TextRange(0, name.length()).shiftRight(se.getSourceElement().getTextOffset() + 1);
            if (def == null) {
                if (!AntAnnotator.isSuccessorOfUndefinedElement(se.getAntParent())) {
                    boolean macroDefined = false;
                    for (parent = se.getAntParent(); parent != null; parent = parent.getAntParent()) {
                        if (!(parent instanceof AntTask) || !((AntTask)parent).isMacroDefined() && !((AntTask)parent).isScriptDefined()) continue;
                        macroDefined = true;
                        break;
                    }
                    Annotation annotation = holder.createErrorAnnotation(absoluteRange, AntBundle.message("undefined.element", name));
                    if (!macroDefined) {
                        AntAnnotator.addDefinitionQuickFixes(annotation, se);
                    }
                }
            } else {
                PsiElement de;
                AntAnnotator.checkValidAttributes(se, def, holder);
                if (!se.hasImportedTypeDefinition() && parent instanceof AntStructuredElement && !AntAnnotator.canBeNested((AntStructuredElement)parent, def) && !AntAnnotator.isSuccessorOfUndefinedElement(se)) {
                    holder.createErrorAnnotation(absoluteRange, AntBundle.message("nested.element.is.not.allowed.here", name));
                }
                if (se instanceof AntTypeDef) {
                    AntTypeDef td = (AntTypeDef)se;
                    if (!td.typesLoaded()) {
                        String failedMessage = AntBundle.message("failed.to.load.types", new Object[0]);
                        if (td.getLocalizedError() != null) {
                            failedMessage = failedMessage + ": " + td.getLocalizedError();
                        }
                        holder.createErrorAnnotation(absoluteRange, failedMessage);
                    }
                } else if (se.isTypeDefined() && (de = def.getDefiningElement()) != null && !((AntTypeDef)de).typesLoaded()) {
                    holder.createWarningAnnotation(absoluteRange, AntBundle.message("using.definition.which.type.failed.to.load", name));
                }
            }
        }
        AntAnnotator.checkReferences(element, holder);
    }

    private static boolean canBeNested(AntStructuredElement parent, AntTypeDefinition maybeNestedDef) {
        AntTypeDefinition parentDef = parent.getTypeDefinition();
        if (parentDef == null) {
            return false;
        }
        return parentDef.isAllTaskContainer() && maybeNestedDef.isTask() || parentDef.getNestedClassName(maybeNestedDef.getTypeId()) != null || AntAnnotator.isExtensionPointType(parent, maybeNestedDef);
    }

    private static boolean isExtensionPointType(AntStructuredElement parent, AntTypeDefinition maybeNested) {
        AntTypeDefinition parentDef = parent.getTypeDefinition();
        return parentDef != null && parentDef.isExtensionPointType(parent.getAntFile().getClassLoader(), maybeNested.getClassName());
    }

    private static boolean isSuccessorOfUndefinedElement(AntElement element) {
        while (element instanceof AntStructuredElement) {
            AntTypeDefinition def = ((AntStructuredElement)element).getTypeDefinition();
            if (def == null) {
                return true;
            }
            PsiElement de = def.getDefiningElement();
            if (de != null && de instanceof AntTypeDef && !((AntTypeDef)de).typesLoaded()) {
                return true;
            }
            element = element.getAntParent();
        }
        return false;
    }

    private static boolean isReferencedPropertyUsedInCondition(AntPropertyReference propRef, AntTarget.ConditionalAttribute conditionalAttribute) {
        String referencedPropertyName = propRef.getCanonicalText();
        if (referencedPropertyName == null) {
            return false;
        }
        AntElement element = propRef.getElement();
        while (element instanceof AntStructuredElement) {
            String conditionalProperty;
            if (element instanceof AntTarget && referencedPropertyName.equals(conditionalProperty = ((AntTarget)element).getConditionalPropertyName(conditionalAttribute))) {
                return true;
            }
            element = element.getAntParent();
        }
        return false;
    }

    private static void addDefinitionQuickFixes(Annotation annotation, AntStructuredElement se) {
        if (se.getSourceElement().getName().length() == 0) {
            return;
        }
        AntProject project = se.getAntProject();
        annotation.registerFix((IntentionAction)new AntCreateMacroDefFix(se));
        annotation.registerFix((IntentionAction)new AntCreatePresetDefFix(se));
        for (AntFile antFile : project.getImportedFiles()) {
            annotation.registerFix((IntentionAction)new AntCreateMacroDefFix(se, antFile));
            annotation.registerFix((IntentionAction)new AntCreatePresetDefFix(se, antFile));
        }
    }

    private static void checkValidAttributes(AntStructuredElement se, AntTypeDefinition def, @NonNls AnnotationHolder holder) {
        XmlTag sourceElement = se.getSourceElement();
        for (XmlAttribute attr : sourceElement.getAttributes()) {
            PsiElement parent;
            String name = attr.getName();
            if (name.startsWith("xmlns")) continue;
            AntAttributeType type = def.getAttributeType(name);
            PsiElement attrName = attr.getFirstChild();
            if (attrName == null) continue;
            if (type == null) {
                if (AntAnnotator.isSuccessorOfUndefinedElement(se)) continue;
                holder.createErrorAnnotation(attrName, AntBundle.message("attribute.is.not.allowed.here", name));
                continue;
            }
            String attrValue = attr.getValue();
            if (type == AntAttributeType.INTEGER) {
                try {
                    Integer.parseInt(se.computeAttributeValue(attrValue));
                }
                catch (NumberFormatException e) {
                    holder.createErrorAnnotation(attrName, AntBundle.message("integer.attribute.has.invalid.value", name));
                }
                continue;
            }
            if (type != AntAttributeType.STRING || attrValue == null || !"pattern".equalsIgnoreCase(name) || !((parent = se.getParent()) instanceof AntProperty) || !((AntProperty)parent).isTstamp()) continue;
            try {
                new SimpleDateFormat(attrValue);
            }
            catch (IllegalArgumentException e) {
                holder.createErrorAnnotation((PsiElement)attr.getValueElement(), e.getMessage());
            }
        }
    }

    private static void checkReferences(AntElement element, @NonNls AnnotationHolder holder) {
        PsiReference[] refs;
        for (PsiReference ref : refs = element.getReferences()) {
            IntentionAction[] intentionActions;
            AntReference antRef;
            if (!(ref instanceof AntReference) || (antRef = (AntReference)ref).shouldBeSkippedByAnnotator() || ref.resolve() != null || antRef instanceof AntPropertyReference && AntAnnotator.isReferencedPropertyUsedInCondition((AntPropertyReference)antRef, AntTarget.ConditionalAttribute.IF)) continue;
            TextRange absoluteRange = ref.getRangeInElement().shiftRight(ref.getElement().getTextRange().getStartOffset());
            Annotation annotation = holder.createErrorAnnotation(absoluteRange, antRef.getUnresolvedMessagePattern());
            annotation.setHighlightType(ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
            for (IntentionAction action : intentionActions = antRef.getFixes()) {
                annotation.registerFix(action);
            }
        }
    }
}

