/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.psi.impl.reference.providers;

import com.intellij.lang.ant.misc.PsiReferenceListSpinAllocator;
import com.intellij.lang.ant.psi.AntStructuredElement;
import com.intellij.lang.ant.psi.AntTask;
import com.intellij.lang.ant.psi.impl.reference.AntElementNameReference;
import com.intellij.lang.ant.psi.impl.reference.AntEndElementNameReference;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ProcessingContext;
import com.intellij.xml.util.XmlTagUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AntElementNameReferenceProvider
extends PsiReferenceProvider {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        AntEndElementNameReference endReference;
        XmlAttribute[] attrs;
        AntTask task;
        PsiReference[] psiReferenceArray;
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/ant/psi/impl/reference/providers/AntElementNameReferenceProvider.getReferencesByElement must not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/lang/ant/psi/impl/reference/providers/AntElementNameReferenceProvider.getReferencesByElement must not be null");
        }
        if (!(element instanceof AntStructuredElement)) {
            psiReferenceArray = PsiReference.EMPTY_ARRAY;
            if (PsiReference.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/impl/reference/providers/AntElementNameReferenceProvider.getReferencesByElement must not return null");
            return psiReferenceArray;
        }
        AntStructuredElement se = (AntStructuredElement)element;
        List<PsiReference> result = PsiReferenceListSpinAllocator.alloc();
        result.add((PsiReference)new AntElementNameReference(se));
        if (element instanceof AntTask && ((task = (AntTask)element).isMacroDefined() || task.isScriptDefined()) && (attrs = task.getSourceElement().getAttributes()).length != 0) {
            for (XmlAttribute attr : attrs) {
                result.add((PsiReference)new AntElementNameReference(task, attr));
            }
        }
        if ((endReference = AntElementNameReferenceProvider.findEndElementNameReference(se)) != null) {
            result.add((PsiReference)endReference);
        }
        PsiReference[] psiReferenceArray2 = result.toArray(new PsiReference[result.size()]);
        psiReferenceArray = psiReferenceArray2;
        if (psiReferenceArray2 != null) return psiReferenceArray;
        throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/impl/reference/providers/AntElementNameReferenceProvider.getReferencesByElement must not return null");
        finally {
            PsiReferenceListSpinAllocator.dispose(result);
        }
    }

    @Nullable
    private static AntEndElementNameReference findEndElementNameReference(AntStructuredElement element) {
        XmlTag tag = element.getSourceElement();
        XmlToken endTagElement = XmlTagUtil.getEndTagNameElement((XmlTag)tag);
        if (endTagElement == null) {
            return null;
        }
        TextRange elementRange = element.getTextRange();
        TextRange endTagRange = endTagElement.getTextRange();
        TextRange refRange = new TextRange(endTagRange.getStartOffset() - elementRange.getStartOffset(), endTagRange.getEndOffset() - elementRange.getStartOffset());
        return new AntEndElementNameReference(element, refRange, AntElementNameReferenceProvider.isClosed((PsiElement)endTagElement));
    }

    private static boolean isClosed(PsiElement current) {
        for (PsiElement e = current; e != null; e = e.getNextSibling()) {
            IElementType tokenType;
            if (!(e instanceof XmlToken) || (tokenType = ((XmlToken)e).getTokenType()) != XmlTokenType.XML_TAG_END && tokenType != XmlTokenType.XML_EMPTY_ELEMENT_END) continue;
            return true;
        }
        return false;
    }
}

