/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.impl;

import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.util.containers.Convertor;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

public final class BuildFileProperty
implements JDOMExternalizable {
    @NonNls
    private static final String NAME = "name";
    @NonNls
    private static final String VALUE = "value";
    private String myPropertyName;
    private String myPropertyValue;
    public static final Convertor<BuildFileProperty, String> TO_COMMAND_LINE = new Convertor<BuildFileProperty, String>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NonNls
        public String convert(BuildFileProperty buildFileProperty) {
            StringBuilder builder = StringBuilderSpinAllocator.alloc();
            try {
                builder.append("-D");
                builder.append(buildFileProperty.getPropertyName());
                builder.append('=');
                builder.append(buildFileProperty.getPropertyValue());
                String string = builder.toString();
                return string;
            }
            finally {
                StringBuilderSpinAllocator.dispose((StringBuilder)builder);
            }
        }
    };

    public BuildFileProperty() {
        this("", "");
    }

    public BuildFileProperty(String propertyName, String propertyValue) {
        this.setPropertyName(propertyName);
        this.myPropertyValue = propertyValue;
    }

    public String getPropertyName() {
        return this.myPropertyName;
    }

    public void setPropertyName(String propertyName) {
        this.myPropertyName = propertyName.trim();
    }

    public String getPropertyValue() {
        return this.myPropertyValue;
    }

    public void setPropertyValue(String propertyValue) {
        this.myPropertyValue = propertyValue;
    }

    public void readExternal(Element element) {
        this.myPropertyName = element.getAttributeValue(NAME);
        this.myPropertyValue = element.getAttributeValue(VALUE);
    }

    public void writeExternal(Element element) {
        element.setAttribute(NAME, this.getPropertyName());
        element.setAttribute(VALUE, this.getPropertyValue());
    }
}

