/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.impl;

import com.intellij.lang.Language;
import com.intellij.lang.ant.AntSupport;
import com.intellij.lang.ant.psi.AntStructuredElement;
import com.intellij.lang.ant.psi.introspection.AntTypeDefinition;
import com.intellij.lang.ant.psi.introspection.AntTypeId;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.xml.breadcrumbs.BreadcrumbsInfoProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AntBreadcrumbsInfoProvider
extends BreadcrumbsInfoProvider {
    private static final Language[] ourSupportedLanguages = new Language[]{AntSupport.getLanguage()};

    public Language[] getLanguages() {
        return ourSupportedLanguages;
    }

    public boolean acceptElement(@NotNull PsiElement e) {
        if (e == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/ant/config/impl/AntBreadcrumbsInfoProvider.acceptElement must not be null");
        }
        return e instanceof AntStructuredElement && e.isValid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public String getElementInfo(@NotNull PsiElement e) {
        String string;
        if (e == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/ant/config/impl/AntBreadcrumbsInfoProvider.getElementInfo must not be null");
        }
        AntStructuredElement se = (AntStructuredElement)e;
        AntTypeDefinition typeDef = se.getTypeDefinition();
        if (typeDef == null) {
            string = se.getSourceElement().getName();
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/lang/ant/config/impl/AntBreadcrumbsInfoProvider.getElementInfo must not return null");
            return string;
        }
        StringBuilder builder = StringBuilderSpinAllocator.alloc();
        AntTypeId typeId = typeDef.getTypeId();
        String nsPrefix = typeId.getNamespacePrefix();
        if (nsPrefix != null) {
            builder.append(nsPrefix);
            builder.append(":");
        }
        builder.append(typeId.getName());
        String name = se.getName();
        if (name != null) {
            builder.append(" ");
            builder.append(name);
        }
        String string2 = builder.toString();
        string = string2;
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/intellij/lang/ant/config/impl/AntBreadcrumbsInfoProvider.getElementInfo must not return null");
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)builder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String getElementTooltip(@NotNull PsiElement e) {
        if (e == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/ant/config/impl/AntBreadcrumbsInfoProvider.getElementTooltip must not be null");
        }
        XmlTag tag = ((AntStructuredElement)e).getSourceElement();
        StringBuilder result = StringBuilderSpinAllocator.alloc();
        try {
            result.append("<");
            result.append(tag.getName());
            for (XmlAttribute attrib : tag.getAttributes()) {
                result.append(" ").append(attrib.getText());
            }
            if (tag.isEmpty()) {
                result.append("/>");
            } else {
                result.append(">...</");
                result.append(tag.getName());
                result.append(">");
            }
            String string = result.toString();
            return string;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)result);
        }
    }
}

