/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.impl;

import com.intellij.lang.ant.config.impl.AntClasspathEntry;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.roots.ui.util.CellAppearanceUtils;
import com.intellij.openapi.roots.ui.util.CompositeAppearance;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

public class AllJarsUnderDirEntry
implements AntClasspathEntry {
    private static final Icon ALL_JARS_IN_DIR_ICON = IconLoader.getIcon((String)"/ant/allJarsInDir.png");
    private final File myDir;
    @NonNls
    static final String DIR = "dir";
    private static final Function<VirtualFile, AntClasspathEntry> CREATE_FROM_VIRTUAL_FILE = new Function<VirtualFile, AntClasspathEntry>(){

        public AntClasspathEntry fun(VirtualFile file) {
            return AllJarsUnderDirEntry.fromVirtualFile(file);
        }
    };
    @NonNls
    public static final String JAR_SUFFIX = ".jar";

    public AllJarsUnderDirEntry(File dir) {
        this.myDir = dir;
    }

    public AllJarsUnderDirEntry(String osPath) {
        this(new File(osPath));
    }

    @Override
    public String getPresentablePath() {
        return this.myDir.getAbsolutePath();
    }

    @Override
    public void writeExternal(Element dataElement) throws WriteExternalException {
        String url = VirtualFileManager.constructUrl((String)"file", (String)this.myDir.getAbsolutePath().replace(File.separatorChar, '/'));
        dataElement.setAttribute(DIR, url);
    }

    @Override
    public void addFilesTo(List<File> files) {
        File[] children = this.myDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().endsWith(AllJarsUnderDirEntry.JAR_SUFFIX) && pathname.isFile();
            }
        });
        if (children != null) {
            files.addAll(Arrays.asList(children));
        }
    }

    @Override
    public CompositeAppearance getAppearance() {
        CompositeAppearance appearance = CellAppearanceUtils.forFile((File)this.myDir);
        appearance.setIcon(ALL_JARS_IN_DIR_ICON);
        return appearance;
    }

    private static AntClasspathEntry fromVirtualFile(VirtualFile file) {
        return new AllJarsUnderDirEntry(file.getPath());
    }

    public static class AddEntriesFactory
    implements Factory<List<AntClasspathEntry>> {
        private final JComponent myParentComponent;

        public AddEntriesFactory(JComponent component) {
            this.myParentComponent = component;
        }

        public List<AntClasspathEntry> create() {
            Object[] files = FileChooser.chooseFiles((Component)this.myParentComponent, (FileChooserDescriptor)new FileChooserDescriptor(false, true, false, false, false, true));
            if (files.length == 0) {
                return null;
            }
            return ContainerUtil.map((Object[])files, (Function)CREATE_FROM_VIRTUAL_FILE);
        }
    }
}

