/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.explorer;

import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.IndexComparator;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.TreeBuilderUtil;
import com.intellij.lang.ant.config.AntBuildFile;
import com.intellij.lang.ant.config.AntConfiguration;
import com.intellij.lang.ant.config.AntConfigurationListener;
import com.intellij.lang.ant.config.explorer.AntExplorerTreeStructure;
import com.intellij.lang.ant.config.explorer.AntNodeDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.ArrayList;
import java.util.Comparator;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

final class AntExplorerTreeBuilder
extends AbstractTreeBuilder {
    private final AntConfigurationListener myAntBuildListener;
    private final Project myProject;

    public AntExplorerTreeBuilder(Project project, JTree tree, DefaultTreeModel treeModel) {
        super(tree, treeModel, (AbstractTreeStructure)new AntExplorerTreeStructure(project), (Comparator)IndexComparator.INSTANCE);
        this.myProject = project;
        this.myAntBuildListener = new ConfigurationListener();
        AntConfiguration.getInstance(this.myProject).addAntConfigurationListener(this.myAntBuildListener);
        this.initRootNode();
    }

    public void dispose() {
        super.dispose();
        AntConfiguration.getInstance(this.myProject).removeAntConfigurationListener(this.myAntBuildListener);
    }

    protected boolean isAlwaysShowPlus(NodeDescriptor nodeDescriptor) {
        return false;
    }

    protected boolean isAutoExpandNode(NodeDescriptor nodeDescriptor) {
        return ((AntNodeDescriptor)nodeDescriptor).isAutoExpand();
    }

    public void setTargetsFiltered(boolean value) {
        ArrayList pathsToExpand = new ArrayList();
        ArrayList selectionPaths = new ArrayList();
        TreeBuilderUtil.storePaths((AbstractTreeBuilder)this, (DefaultMutableTreeNode)this.getRootNode(), pathsToExpand, selectionPaths, (boolean)true);
        ((AntExplorerTreeStructure)this.getTreeStructure()).setFilteredTargets(value);
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                AntExplorerTreeBuilder.this.updateFromRoot();
            }
        });
        this.getTree().setSelectionPaths(new TreePath[0]);
        TreeBuilderUtil.restorePaths((AbstractTreeBuilder)this, pathsToExpand, selectionPaths, (boolean)true);
    }

    public void refresh() {
        ArrayList pathsToExpand = new ArrayList();
        ArrayList selectionPaths = new ArrayList();
        TreeBuilderUtil.storePaths((AbstractTreeBuilder)this, (DefaultMutableTreeNode)this.getRootNode(), pathsToExpand, selectionPaths, (boolean)true);
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                AntExplorerTreeBuilder.this.updateFromRoot();
            }
        });
        this.getTree().setSelectionPaths(new TreePath[0]);
        TreeBuilderUtil.restorePaths((AbstractTreeBuilder)this, pathsToExpand, selectionPaths, (boolean)true);
    }

    protected ProgressIndicator createProgressIndicator() {
        return super.createProgressIndicator();
    }

    public void expandAll() {
        ArrayList pathsToExpand = new ArrayList();
        ArrayList selectionPaths = new ArrayList();
        TreeBuilderUtil.storePaths((AbstractTreeBuilder)this, (DefaultMutableTreeNode)this.getRootNode(), pathsToExpand, selectionPaths, (boolean)true);
        for (int row = 0; row < this.getTree().getRowCount(); ++row) {
            this.getTree().expandRow(row);
        }
        this.getTree().setSelectionPaths(new TreePath[0]);
        TreeBuilderUtil.restorePaths((AbstractTreeBuilder)this, pathsToExpand, selectionPaths, (boolean)true);
    }

    void collapseAll() {
        ArrayList pathsToExpand = new ArrayList();
        ArrayList selectionPaths = new ArrayList();
        TreeBuilderUtil.storePaths((AbstractTreeBuilder)this, (DefaultMutableTreeNode)this.getRootNode(), pathsToExpand, selectionPaths, (boolean)true);
        TreeUtil.collapseAll((JTree)this.getTree(), (int)1);
        this.getTree().setSelectionPaths(new TreePath[0]);
        pathsToExpand.clear();
        TreeBuilderUtil.restorePaths((AbstractTreeBuilder)this, pathsToExpand, selectionPaths, (boolean)true);
    }

    private final class ConfigurationListener
    implements AntConfigurationListener {
        private ConfigurationListener() {
        }

        @Override
        public void configurationLoaded() {
            AntExplorerTreeBuilder.this.getUpdater().addSubtreeToUpdate(AntExplorerTreeBuilder.this.getRootNode());
        }

        @Override
        public void buildFileAdded(AntBuildFile buildFile) {
            AntExplorerTreeBuilder.this.getUpdater().addSubtreeToUpdate(AntExplorerTreeBuilder.this.getRootNode());
        }

        @Override
        public void buildFileChanged(AntBuildFile buildFile) {
            AntExplorerTreeBuilder.this.getUpdater().addSubtreeToUpdateByElement((Object)buildFile);
        }

        @Override
        public void buildFileRemoved(AntBuildFile buildFile) {
            AntExplorerTreeBuilder.this.getUpdater().addSubtreeToUpdate(AntExplorerTreeBuilder.this.getRootNode());
        }
    }
}

