/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject.config.ui;

import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.ui.EditorTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.Consumer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.intellij.lang.regexp.RegExpLanguage;
import org.intellij.plugins.intelliLang.inject.InjectedLanguage;
import org.intellij.plugins.intelliLang.inject.config.AbstractTagInjection;
import org.intellij.plugins.intelliLang.inject.config.BaseInjection;
import org.intellij.plugins.intelliLang.inject.config.XPathSupportProxy;
import org.intellij.plugins.intelliLang.inject.config.ui.AbstractInjectionPanel;
import org.intellij.plugins.intelliLang.inject.config.ui.ValueRegExpAnnotator;
import org.intellij.plugins.intelliLang.util.LanguageTextField;

public class AdvancedPanel
extends AbstractInjectionPanel<BaseInjection> {
    private JPanel myRoot;
    private EditorTextField myValuePattern;
    private EditorTextField myXPathCondition;
    private JLabel myXPathConditionLabel;
    private JCheckBox mySingleFileCheckBox;

    public AdvancedPanel(Project project, BaseInjection injection) {
        super(injection, project);
        this.$$$setupUI$$$();
        if (!(injection instanceof AbstractTagInjection)) {
            this.myXPathCondition.setVisible(false);
            this.myXPathConditionLabel.setVisible(false);
        }
    }

    @Override
    protected void apply(BaseInjection other) {
        other.setValuePattern(this.myValuePattern.getText());
        other.setSingleFile(this.mySingleFileCheckBox.isSelected());
        if (this.myOrigInjection instanceof AbstractTagInjection) {
            ((AbstractTagInjection)other).setXPathCondition(this.myXPathCondition.getText());
        }
    }

    @Override
    protected void resetImpl() {
        this.myValuePattern.setText(this.myOrigInjection.getValuePattern());
        this.mySingleFileCheckBox.setSelected(this.myOrigInjection.isSingleFile());
        if (this.myOrigInjection instanceof AbstractTagInjection) {
            this.myXPathCondition.setText(((AbstractTagInjection)this.myOrigInjection).getXPathCondition());
        }
    }

    @Override
    public JPanel getComponent() {
        return this.myRoot;
    }

    private void createUIComponents() {
        XPathSupportProxy proxy;
        this.myValuePattern = new LanguageTextField((Language)RegExpLanguage.INSTANCE, this.myProject, this.myOrigInjection.getValuePattern(), new Consumer<PsiFile>(){

            public void consume(PsiFile psiFile) {
                psiFile.putCopyableUserData(ValueRegExpAnnotator.KEY, (Object)Boolean.TRUE);
            }
        });
        this.myXPathCondition = this.myOrigInjection instanceof AbstractTagInjection ? new LanguageTextField((proxy = XPathSupportProxy.getInstance()) != null ? InjectedLanguage.findLanguageById("XPath") : null, this.myProject, ((AbstractTagInjection)this.myOrigInjection).getXPathCondition(), new Consumer<PsiFile>(){

            public void consume(PsiFile psiFile) {
                if (proxy != null) {
                    proxy.attachContext(psiFile);
                }
            }
        }) : new EditorTextField();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JLabel jLabel;
        JPanel jPanel;
        this.createUIComponents();
        this.myRoot = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(BorderFactory.createTitledBorder(null, "Advanced", 0, 0, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Value Pattern:");
        jLabel2.setDisplayedMnemonic('V');
        jLabel2.setDisplayedMnemonicIndex(0);
        jLabel2.setToolTipText("<html>Enter a regular expression that selects the parts of the tag's or attribute's value the language should be injected into.<br>The pattern should contain exactly one capturing group.</html>");
        jPanel2.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        EditorTextField editorTextField = this.myValuePattern;
        jPanel2.add((Component)editorTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 7, 0, null, new Dimension(150, -1), null));
        this.myXPathConditionLabel = jLabel = new JLabel();
        jLabel.setText("XPath Condition:");
        jLabel.setDisplayedMnemonic('X');
        jLabel.setDisplayedMnemonicIndex(0);
        jLabel.setToolTipText("<html>Enter an XPath expression that the tag/attribute must match additionally to the name-condition specified above.<br>This requires the XPathView plugin to be installed</html>");
        jPanel2.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        EditorTextField editorTextField2 = this.myXPathCondition;
        jPanel2.add((Component)editorTextField2, new GridConstraints(1, 1, 1, 2, 8, 1, 7, 0, null, new Dimension(150, -1), null));
        this.mySingleFileCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Single File");
        jCheckBox.setMnemonic('S');
        jCheckBox.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jCheckBox, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        jLabel2.setLabelFor((Component)editorTextField);
        jLabel.setLabelFor((Component)editorTextField2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRoot;
    }
}

