/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject;

import com.intellij.lang.DependentLanguage;
import com.intellij.lang.InjectableLanguage;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.psi.templateLanguages.TemplateLanguage;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InjectedLanguage {
    private static Map<String, Language> ourLanguageCache;
    private static int ourLanguageCount;
    private final String myID;
    private final String myPrefix;
    private final String mySuffix;
    private final boolean myDynamic;

    private InjectedLanguage(@NotNull String id, @NotNull String prefix, @NotNull String suffix, boolean dynamic) {
        if (id == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/intellij/plugins/intelliLang/inject/InjectedLanguage.<init> must not be null");
        }
        if (prefix == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/intellij/plugins/intelliLang/inject/InjectedLanguage.<init> must not be null");
        }
        if (suffix == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/intellij/plugins/intelliLang/inject/InjectedLanguage.<init> must not be null");
        }
        this.myID = id;
        this.myPrefix = prefix;
        this.mySuffix = suffix;
        this.myDynamic = dynamic;
    }

    @NotNull
    public String getID() {
        String string = this.myID;
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/intellij/plugins/intelliLang/inject/InjectedLanguage.getID must not return null");
        }
        return string;
    }

    @Nullable
    public Language getLanguage() {
        return InjectedLanguage.findLanguageById(this.myID);
    }

    @NotNull
    public String getPrefix() {
        String string = this.myPrefix;
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/intellij/plugins/intelliLang/inject/InjectedLanguage.getPrefix must not return null");
        }
        return string;
    }

    @NotNull
    public String getSuffix() {
        String string = this.mySuffix;
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/intellij/plugins/intelliLang/inject/InjectedLanguage.getSuffix must not return null");
        }
        return string;
    }

    public boolean isDynamic() {
        return this.myDynamic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Language findLanguageById(@Nullable String langID) {
        if (langID == null || langID.length() == 0) {
            return null;
        }
        Class<InjectedLanguage> clazz = InjectedLanguage.class;
        synchronized (InjectedLanguage.class) {
            if (ourLanguageCache == null || ourLanguageCount != Language.getRegisteredLanguages().size()) {
                InjectedLanguage.initLanguageCache();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return ourLanguageCache.get(langID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static String[] getAvailableLanguageIDs() {
        Class<InjectedLanguage> clazz = InjectedLanguage.class;
        synchronized (InjectedLanguage.class) {
            if (ourLanguageCache == null || ourLanguageCount != Language.getRegisteredLanguages().size()) {
                InjectedLanguage.initLanguageCache();
            }
            Set<String> keys = ourLanguageCache.keySet();
            String[] stringArray = ArrayUtil.toStringArray(keys);
            // ** MonitorExit[var0] (shouldn't be in output)
            if (stringArray == null) {
                throw new IllegalStateException("@NotNull method org/intellij/plugins/intelliLang/inject/InjectedLanguage.getAvailableLanguageIDs must not return null");
            }
            return stringArray;
        }
    }

    private static void initLanguageCache() {
        ArrayList registeredLanguages;
        ourLanguageCache = new HashMap<String, Language>();
        do {
            registeredLanguages = new ArrayList(Language.getRegisteredLanguages());
            for (Language language : registeredLanguages) {
                if (!InjectedLanguage.isInjectableLanguage(language)) continue;
                ourLanguageCache.put(language.getID(), language);
            }
        } while (Language.getRegisteredLanguages().size() != registeredLanguages.size());
        ourLanguageCount = registeredLanguages.size();
    }

    private static boolean isInjectableLanguage(Language language) {
        if (language == Language.ANY || language == FileTypes.PLAIN_TEXT.getLanguage()) {
            return false;
        }
        if (language.getID().startsWith("$")) {
            return false;
        }
        if (language instanceof InjectableLanguage) {
            return true;
        }
        if (language instanceof TemplateLanguage || language instanceof DependentLanguage) {
            return false;
        }
        return LanguageParserDefinitions.INSTANCE.forLanguage(language) != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InjectedLanguage that = (InjectedLanguage)o;
        return !(this.myID == null ? that.myID != null : !this.myID.equals(that.myID));
    }

    public int hashCode() {
        return this.myID != null ? this.myID.hashCode() : 0;
    }

    @Nullable
    public static InjectedLanguage create(String id) {
        return InjectedLanguage.create(id, "", "", false);
    }

    @Nullable
    public static InjectedLanguage create(@Nullable String id, String prefix, String suffix, boolean isDynamic) {
        return id == null ? null : new InjectedLanguage(id, prefix == null ? "" : prefix, suffix == null ? "" : suffix, isDynamic);
    }
}

