/*
 * Decompiled with CFR 0.152.
 */
package git4idea.vfs;

import com.intellij.ProjectTopics;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandAdapter;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.VcsListener;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileManagerListener;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.ex.VirtualFileManagerAdapter;
import com.intellij.openapi.vfs.ex.VirtualFileManagerEx;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.i18n.GitBundle;
import git4idea.vfs.GitFixRootsDialog;
import git4idea.vfs.GitRootsListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitRootTracker
implements VcsListener {
    private final Project myProject;
    private final ProjectRootManager myProjectRoots;
    private final ProjectLevelVcsManager myVcsManager;
    private final GitVcs myVcs;
    private final AtomicBoolean myIsEnabled;
    private final AtomicBoolean myRootsInvalidated;
    private final AtomicBoolean myHasGitRoots;
    private final AtomicBoolean myNotificationPosted;
    private final MergingUpdateQueue myQueue;
    private Notification myNotification;
    private static final String GIT_INVALID_ROOTS_ID = "Git";
    private CommandListener myCommandListener;
    private MyFileListener myFileListener;
    private VirtualFileManagerAdapter myVirtualFileManagerListener;
    private LocalFileSystem myLocalFileSystem;
    private GitRootsListener myMulticaster;
    private final MessageBusConnection myMessageBusConnection;

    public GitRootTracker(GitVcs vcs, @NotNull Project project, @NotNull GitRootsListener multicaster) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of git4idea/vfs/GitRootTracker.<init> must not be null");
        }
        if (multicaster == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of git4idea/vfs/GitRootTracker.<init> must not be null");
        }
        this.myIsEnabled = new AtomicBoolean(false);
        this.myRootsInvalidated = new AtomicBoolean(true);
        this.myHasGitRoots = new AtomicBoolean(true);
        this.myNotificationPosted = new AtomicBoolean(false);
        this.myMulticaster = multicaster;
        if (project.isDefault()) {
            throw new IllegalArgumentException("The project must not be default");
        }
        this.myProject = project;
        this.myProjectRoots = ProjectRootManager.getInstance((Project)this.myProject);
        this.myQueue = new MergingUpdateQueue("queue", 500, true, null, (Disposable)project, null, false);
        this.myVcs = vcs;
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        this.myVcsManager.addVcsListener((VcsListener)this);
        this.myLocalFileSystem = LocalFileSystem.getInstance();
        this.myMessageBusConnection = this.myProject.getMessageBus().connect();
        this.myMessageBusConnection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void beforeRootsChange(ModuleRootEvent event) {
            }

            public void rootsChanged(ModuleRootEvent event) {
                GitRootTracker.this.invalidate();
            }
        });
        this.myCommandListener = new CommandAdapter(){

            public void commandFinished(CommandEvent event) {
                if (!GitRootTracker.this.myRootsInvalidated.compareAndSet(true, false)) {
                    return;
                }
                GitRootTracker.this.scheduleRootsCheck(false);
            }
        };
        CommandProcessor.getInstance().addCommandListener(this.myCommandListener);
        this.myFileListener = new MyFileListener();
        VirtualFileManagerEx fileManager = (VirtualFileManagerEx)VirtualFileManager.getInstance();
        fileManager.addVirtualFileListener((VirtualFileListener)this.myFileListener);
        this.myVirtualFileManagerListener = new VirtualFileManagerAdapter(){

            public void afterRefreshFinish(boolean asynchonous) {
                if (!GitRootTracker.this.myRootsInvalidated.compareAndSet(true, false)) {
                    return;
                }
                GitRootTracker.this.scheduleRootsCheck(false);
            }
        };
        fileManager.addVirtualFileManagerListener((VirtualFileManagerListener)this.myVirtualFileManagerListener);
        StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(new Runnable(){

            @Override
            public void run() {
                GitRootTracker.this.myIsEnabled.set(true);
                GitRootTracker.this.scheduleRootsCheck(true);
            }
        });
    }

    public void dispose() {
        this.myVcsManager.removeVcsListener((VcsListener)this);
        this.myMessageBusConnection.disconnect();
        CommandProcessor.getInstance().removeCommandListener(this.myCommandListener);
        VirtualFileManagerEx fileManager = (VirtualFileManagerEx)VirtualFileManager.getInstance();
        fileManager.removeVirtualFileListener((VirtualFileListener)this.myFileListener);
        fileManager.removeVirtualFileManagerListener((VirtualFileManagerListener)this.myVirtualFileManagerListener);
    }

    public void directoryMappingChanged() {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                GitRootTracker.this.scheduleRootsCheck(true);
            }
        });
    }

    private void scheduleRootsCheck(final boolean rootsChanged) {
        if (ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment()) {
            this.doCheckRoots(rootsChanged);
            return;
        }
        this.myQueue.queue(new Update("root check"){

            public void run() {
                if (GitRootTracker.this.myProject.isDisposed()) {
                    return;
                }
                GitRootTracker.this.doCheckRoots(rootsChanged);
            }
        });
    }

    private void doCheckRoots(boolean rootsChanged) {
        if (!this.myIsEnabled.get() || !rootsChanged && !this.myHasGitRoots.get()) {
            return;
        }
        final HashSet<VirtualFile> rootSet = new HashSet<VirtualFile>();
        boolean hasInvalidRoots = (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                for (VcsDirectoryMapping m : GitRootTracker.this.myVcsManager.getDirectoryMappings()) {
                    VirtualFile root;
                    if (!m.getVcs().equals(GitRootTracker.this.myVcs.getName())) continue;
                    String path = m.getDirectory();
                    if (path.length() == 0) {
                        VirtualFile baseDir = GitRootTracker.this.myProject.getBaseDir();
                        assert (baseDir != null);
                        path = baseDir.getPath();
                    }
                    if ((root = GitRootTracker.this.lookupFile(path)) == null || rootSet.contains(root)) {
                        return true;
                    }
                    rootSet.add(root);
                }
                return false;
            }
        });
        if (!hasInvalidRoots && rootSet.isEmpty()) {
            this.myHasGitRoots.set(false);
            return;
        }
        this.myHasGitRoots.set(true);
        if (!hasInvalidRoots) {
            VirtualFile root;
            Iterator i$ = rootSet.iterator();
            while (i$.hasNext() && !(hasInvalidRoots = GitRootTracker.hasUnmappedSubroots(root = (VirtualFile)i$.next(), rootSet))) {
            }
        }
        if (!hasInvalidRoots) {
            if (this.myNotificationPosted.compareAndSet(true, false)) {
                UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (GitRootTracker.this.myNotification != null) {
                            if (!GitRootTracker.this.myNotification.isExpired()) {
                                GitRootTracker.this.myNotification.expire();
                            }
                            GitRootTracker.this.myNotification = null;
                        }
                    }
                });
            }
        } else if (this.myNotificationPosted.compareAndSet(false, true)) {
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    GitRootTracker.this.myNotification = new Notification(GitRootTracker.GIT_INVALID_ROOTS_ID, GitBundle.getString("root.tracker.message.title"), GitBundle.getString("root.tracker.message"), NotificationType.ERROR, new NotificationListener(){

                        public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                            if (notification == null) {
                                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/vfs/GitRootTracker$9$1.hyperlinkUpdate must not be null");
                            }
                            if (event == null) {
                                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of git4idea/vfs/GitRootTracker$9$1.hyperlinkUpdate must not be null");
                            }
                            if (GitRootTracker.this.fixRoots()) {
                                notification.expire();
                            }
                        }
                    });
                    Notifications.Bus.notify((Notification)GitRootTracker.this.myNotification, (Project)GitRootTracker.this.myProject);
                }
            });
        }
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                GitRootTracker.this.myMulticaster.gitRootsChanged();
            }
        });
    }

    private static boolean hasUnmappedSubroots(final VirtualFile directory, @NotNull HashSet<VirtualFile> rootSet) {
        VirtualFile[] children;
        if (rootSet == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of git4idea/vfs/GitRootTracker.hasUnmappedSubroots must not be null");
        }
        for (VirtualFile child : children = (VirtualFile[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<VirtualFile[]>(){

            public VirtualFile[] compute() {
                return directory.isValid() ? directory.getChildren() : VirtualFile.EMPTY_ARRAY;
            }
        })) {
            if (!child.isDirectory()) continue;
            if (child.getName().equals(".git")) {
                return !rootSet.contains(child.getParent());
            }
            if (!GitRootTracker.hasUnmappedSubroots(child, rootSet)) continue;
            return true;
        }
        return false;
    }

    boolean fixRoots() {
        final ArrayList<VcsDirectoryMapping> vcsDirectoryMappings = new ArrayList<VcsDirectoryMapping>(this.myVcsManager.getDirectoryMappings());
        final HashSet<String> mapped = new HashSet<String>();
        final HashSet<String> removed = new HashSet<String>();
        final HashSet<String> added = new HashSet<String>();
        final VirtualFile baseDir = this.myProject.getBaseDir();
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                Iterator i = vcsDirectoryMappings.iterator();
                while (i.hasNext()) {
                    VirtualFile file;
                    Object m = (VcsDirectoryMapping)i.next();
                    String vcsName = GitRootTracker.this.myVcs.getName();
                    if (!vcsName.equals(m.getVcs())) continue;
                    String path = m.getDirectory();
                    if (path.length() == 0 && baseDir != null) {
                        path = baseDir.getPath();
                    }
                    if ((file = GitRootTracker.this.lookupFile(path)) != null && !mapped.add(file.getPath())) {
                        i.remove();
                        continue;
                    }
                    if (file != null && GitUtil.gitRootOrNull(file) != null) continue;
                    removed.add(path);
                }
                for (Object m : mapped) {
                    VirtualFile file = GitRootTracker.this.lookupFile((String)m);
                    if (file == null) continue;
                    GitRootTracker.addSubroots(file, added, mapped);
                    if (removed.contains(m)) continue;
                    VirtualFile root = GitUtil.gitRootOrNull(file);
                    assert (root != null);
                    for (String o : mapped) {
                        if (o.equals(m) || removed.contains(o) || !o.startsWith((String)m)) continue;
                        VirtualFile otherFile = GitRootTracker.this.lookupFile((String)m);
                        assert (otherFile != null);
                        VirtualFile otherRoot = GitUtil.gitRootOrNull(otherFile);
                        assert (otherRoot != null);
                        if (otherRoot == root) {
                            removed.add(o);
                            continue;
                        }
                        if (otherFile == otherRoot) continue;
                        added.add(otherRoot.getPath());
                        removed.add(o);
                    }
                }
            }
        });
        if (added.isEmpty() && removed.isEmpty()) {
            Messages.showInfoMessage((Project)this.myProject, (String)GitBundle.message("fix.roots.valid.message", new Object[0]), (String)GitBundle.message("fix.roots.valid.title", new Object[0]));
            return true;
        }
        GitFixRootsDialog d = new GitFixRootsDialog(this.myProject, mapped, added, removed);
        d.show();
        if (!d.isOK()) {
            return false;
        }
        Iterator i = vcsDirectoryMappings.iterator();
        while (i.hasNext()) {
            VcsDirectoryMapping m = (VcsDirectoryMapping)i.next();
            String path = m.getDirectory();
            if (!removed.contains(path) && (path.length() != 0 || baseDir == null || !removed.contains(baseDir.getPath()))) continue;
            i.remove();
        }
        for (String a : added) {
            vcsDirectoryMappings.add(new VcsDirectoryMapping(a, this.myVcs.getName()));
        }
        this.myVcsManager.setDirectoryMappings(vcsDirectoryMappings);
        this.myVcsManager.updateActiveVcss();
        return true;
    }

    @Nullable
    private VirtualFile lookupFile(String path) {
        return this.myLocalFileSystem.findFileByPath(path);
    }

    private static void addSubroots(VirtualFile directory, HashSet<String> toAdd, HashSet<String> mapped) {
        for (VirtualFile child : directory.getChildren()) {
            if (!child.isDirectory()) continue;
            if (child.getName().equals(".git") && !mapped.contains(directory.getPath())) {
                toAdd.add(directory.getPath());
                continue;
            }
            GitRootTracker.addSubroots(child, toAdd, mapped);
        }
    }

    private void invalidate() {
        this.myRootsInvalidated.set(true);
    }

    private class MyFileListener
    extends VirtualFileAdapter {
        private MyFileListener() {
        }

        private boolean hasGitRepositories(VirtualFile file) {
            if (!file.isDirectory() || !file.getName().equals(".git")) {
                return false;
            }
            VirtualFile baseDir = GitRootTracker.this.myProject.getBaseDir();
            if (baseDir == null) {
                return false;
            }
            if (!VfsUtil.isAncestor((VirtualFile)baseDir, (VirtualFile)file, (boolean)false)) {
                boolean isUnder = false;
                for (VirtualFile c : GitRootTracker.this.myProjectRoots.getContentRoots()) {
                    if (VfsUtil.isAncestor((VirtualFile)baseDir, (VirtualFile)c, (boolean)false) || !VfsUtil.isAncestor((VirtualFile)c, (VirtualFile)file, (boolean)false)) continue;
                    isUnder = true;
                    break;
                }
                if (!isUnder) {
                    return false;
                }
            }
            return true;
        }

        public void fileCreated(VirtualFileEvent event) {
            if (!GitRootTracker.this.myHasGitRoots.get()) {
                return;
            }
            if (this.hasGitRepositories(event.getFile())) {
                GitRootTracker.this.invalidate();
            }
        }

        public void beforeFileDeletion(VirtualFileEvent event) {
            if (!GitRootTracker.this.myHasGitRoots.get()) {
                return;
            }
            if (this.hasGitRepositories(event.getFile())) {
                GitRootTracker.this.invalidate();
            }
        }

        public void fileMoved(VirtualFileMoveEvent event) {
            if (!GitRootTracker.this.myHasGitRoots.get()) {
                return;
            }
            if (this.hasGitRepositories(event.getFile())) {
                GitRootTracker.this.invalidate();
            }
        }

        public void fileCopied(VirtualFileCopyEvent event) {
            if (!GitRootTracker.this.myHasGitRoots.get()) {
                return;
            }
            if (this.hasGitRepositories(event.getFile())) {
                GitRootTracker.this.invalidate();
            }
        }
    }
}

