/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.UIUtil;
import git4idea.commands.GitHandler;
import git4idea.rebase.GitRebaseEditor;
import git4idea.rebase.GitRebaseEditorHandler;
import git4idea.rebase.GitRebaseEditorService;
import git4idea.rebase.GitRebaseUnstructuredEditor;
import java.io.Closeable;
import org.jetbrains.annotations.NotNull;

public class GitInteractiveRebaseEditorHandler
implements Closeable,
GitRebaseEditorHandler {
    private static final Logger LOG = Logger.getInstance((String)GitInteractiveRebaseEditorHandler.class.getName());
    private final GitRebaseEditorService myService;
    private final Project myProject;
    private final VirtualFile myRoot;
    private GitHandler myHandler;
    private int myHandlerNo;
    private boolean myIsClosed;
    protected boolean myRebaseEditorShown;

    public GitInteractiveRebaseEditorHandler(@NotNull GitRebaseEditorService service, @NotNull Project project, @NotNull VirtualFile root, @NotNull GitHandler handler) {
        if (service == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/rebase/GitInteractiveRebaseEditorHandler.<init> must not be null");
        }
        if (project == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of git4idea/rebase/GitInteractiveRebaseEditorHandler.<init> must not be null");
        }
        if (root == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of git4idea/rebase/GitInteractiveRebaseEditorHandler.<init> must not be null");
        }
        if (handler == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of git4idea/rebase/GitInteractiveRebaseEditorHandler.<init> must not be null");
        }
        this.myRebaseEditorShown = false;
        this.myService = service;
        this.myProject = project;
        this.myRoot = root;
        this.myHandler = handler;
        this.myHandlerNo = service.registerHandler(this);
    }

    @Override
    public GitHandler getHandler() {
        return this.myHandler;
    }

    @Override
    public int editCommits(final String path) {
        this.ensureOpen();
        final Ref isSuccess = new Ref();
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    if (GitInteractiveRebaseEditorHandler.this.myRebaseEditorShown) {
                        GitRebaseUnstructuredEditor editor = new GitRebaseUnstructuredEditor(GitInteractiveRebaseEditorHandler.this.myProject, GitInteractiveRebaseEditorHandler.this.myRoot, path);
                        editor.show();
                        if (editor.isOK()) {
                            editor.save();
                            isSuccess.set((Object)true);
                            return;
                        }
                        isSuccess.set((Object)false);
                    } else {
                        GitInteractiveRebaseEditorHandler.this.setRebaseEditorShown();
                        GitRebaseEditor editor = new GitRebaseEditor(GitInteractiveRebaseEditorHandler.this.myProject, GitInteractiveRebaseEditorHandler.this.myRoot, path);
                        editor.show();
                        if (editor.isOK()) {
                            editor.save();
                            isSuccess.set((Object)true);
                            return;
                        }
                        editor.cancel();
                        isSuccess.set((Object)true);
                    }
                }
                catch (Exception e) {
                    LOG.error("Failed to edit the git rebase file: " + path, (Throwable)e);
                }
                isSuccess.set((Object)false);
            }
        });
        return isSuccess.isNull() || (Boolean)isSuccess.get() == false ? 2 : 0;
    }

    public void setRebaseEditorShown() {
        this.myRebaseEditorShown = true;
    }

    private void ensureOpen() {
        if (this.myIsClosed) {
            throw new IllegalStateException("The handler was already closed");
        }
    }

    @Override
    public void close() {
        this.ensureOpen();
        this.myIsClosed = true;
        this.myService.unregisterHandler(this.myHandlerNo);
    }

    public int getHandlerNo() {
        return this.myHandlerNo;
    }
}

