/*
 * Decompiled with CFR 0.152.
 */
package git4idea.merge;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.update.FileGroup;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.commands.GitCommand;
import git4idea.commands.GitSimpleHandler;
import git4idea.commands.StringScanner;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;

public class MergeChangeCollector {
    private final HashSet<String> myUnmergedPaths = new HashSet();
    private final Project myProject;
    private final VirtualFile myRoot;
    private final UpdatedFiles myUpdates;
    private final GitRevisionNumber myStart;

    public MergeChangeCollector(Project project, VirtualFile root, GitRevisionNumber start, UpdatedFiles updates) {
        this.myStart = start;
        this.myProject = project;
        this.myRoot = root;
        this.myUpdates = updates;
    }

    /*
     * Unable to fully structure code
     */
    public void collect(List<VcsException> exceptions) {
        vcsKey = GitVcs.getKey();
        try {
            root = this.myRoot.getPath();
            h = new GitSimpleHandler(this.myProject, this.myRoot, GitCommand.LS_FILES);
            h.setNoSSH(true);
            h.setSilent(true);
            h.addParameters(new String[]{"--unmerged"});
            s = new StringScanner(h.run());
            while (s.hasMoreData()) {
                if (s.isEol()) {
                    s.nextLine();
                    continue;
                }
                s.boundedToken('\t');
                relative = s.line();
                if (!this.myUnmergedPaths.add(relative)) continue;
                path = root + "/" + GitUtil.unescapePath(relative);
                this.myUpdates.getGroupById("MERGED_WITH_CONFLICTS").add(path, vcsKey, null);
            }
            currentHead = GitRevisionNumber.resolve(this.myProject, this.myRoot, "HEAD");
            updated = new TreeSet<String>();
            created = new TreeSet<String>();
            removed = new TreeSet<String>();
            if (currentHead.equals(this.myStart)) {
                mergeHeadsFile = new File(root, ".git/MERGE_HEAD");
                try {
                    if (!mergeHeadsFile.exists()) ** GOTO lbl41
                    mergeHeads = new String(FileUtil.loadFileText((File)mergeHeadsFile, (String)"UTF-8"));
                    s = new StringScanner(mergeHeads);
                    while (s.hasMoreData()) {
                        head = s.line();
                        if (head.length() == 0) continue;
                        this.processDiff(root, updated, created, removed, this.myStart.getRev() + "..." + head);
                    }
                }
                catch (IOException e) {
                    exceptions.add(new VcsException("Unable to read the file " + mergeHeadsFile + ": " + e.getMessage(), (Throwable)e));
                }
            } else {
                this.processDiff(root, updated, created, removed, this.myStart.getRev() + "..HEAD");
            }
lbl41:
            // 4 sources

            this.addAll("UPDATED", updated);
            this.addAll("CREATED", created);
            this.addAll("REMOVED_FROM_REPOSITORY", removed);
        }
        catch (VcsException e) {
            exceptions.add(e);
        }
    }

    private void processDiff(String root, TreeSet<String> updated, TreeSet<String> created, TreeSet<String> removed, String revisions) throws VcsException {
        GitSimpleHandler h = new GitSimpleHandler(this.myProject, this.myRoot, GitCommand.DIFF);
        h.setSilent(true);
        h.setNoSSH(true);
        h.addParameters("--name-status", "--diff-filter=ADMRUX", revisions);
        StringScanner s = new StringScanner(h.run());
        block5: while (s.hasMoreData()) {
            if (s.isEol()) {
                s.nextLine();
                continue;
            }
            char status = s.peek();
            s.boundedToken('\t');
            String relative = s.line();
            if (this.myUnmergedPaths.contains(relative)) continue;
            String path = root + "/" + GitUtil.unescapePath(relative);
            switch (status) {
                case 'M': {
                    updated.add(path);
                    continue block5;
                }
                case 'A': {
                    created.add(path);
                    continue block5;
                }
                case 'D': {
                    removed.add(path);
                    continue block5;
                }
            }
            throw new IllegalStateException("Unexpected status: " + status);
        }
    }

    private void addAll(String id, TreeSet<String> paths) {
        FileGroup fileGroup = this.myUpdates.getGroupById(id);
        VcsKey vcsKey = GitVcs.getKey();
        for (String path : paths) {
            fileGroup.add(path, vcsKey, null);
        }
    }
}

