/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.history.HistoryAsTreeProvider;
import com.intellij.openapi.vcs.history.VcsAbstractHistorySession;
import com.intellij.openapi.vcs.history.VcsAppendableHistorySessionPartner;
import com.intellij.openapi.vcs.history.VcsDependentHistoryComponents;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsHistorySession;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.util.Consumer;
import com.intellij.util.ui.ColumnInfo;
import git4idea.GitFileRevision;
import git4idea.actions.GitShowAllSubmittedFilesAction;
import git4idea.history.GitCopyHistoryRevisionNumberAction;
import git4idea.history.GitHistoryUtils;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitHistoryProvider
implements VcsHistoryProvider {
    private static final Logger log = Logger.getInstance((String)GitHistoryProvider.class.getName());
    private final Project project;

    public GitHistoryProvider(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/history/GitHistoryProvider.<init> must not be null");
        }
        this.project = project;
    }

    public VcsDependentHistoryComponents getUICustomization(VcsHistorySession session, JComponent forShortcutRegistration) {
        return VcsDependentHistoryComponents.createOnlyColumns((ColumnInfo[])new ColumnInfo[0]);
    }

    public AnAction[] getAdditionalActions(Runnable refresher) {
        return new AnAction[]{new GitShowAllSubmittedFilesAction(), new GitCopyHistoryRevisionNumberAction()};
    }

    public boolean isDateOmittable() {
        return false;
    }

    @Nullable
    public String getHelpId() {
        return null;
    }

    @Nullable
    public VcsHistorySession createSessionFor(final FilePath filePath) throws VcsException {
        if (filePath.isDirectory()) {
            return null;
        }
        List<VcsFileRevision> revisions = GitHistoryUtils.history(this.project, filePath);
        return new VcsAbstractHistorySession(revisions){

            @Nullable
            protected VcsRevisionNumber calcCurrentRevisionNumber() {
                try {
                    return GitHistoryUtils.getCurrentRevision(GitHistoryProvider.this.project, GitHistoryUtils.getLastCommitName(GitHistoryProvider.this.project, filePath));
                }
                catch (VcsException e) {
                    if (log.isDebugEnabled()) {
                        log.debug("Unable to retrieve the current revision number", (Throwable)e);
                    }
                    return null;
                }
            }

            public HistoryAsTreeProvider getHistoryAsTreeProvider() {
                return null;
            }
        };
    }

    public void reportAppendableHistory(final FilePath path, final VcsAppendableHistorySessionPartner partner) throws VcsException {
        VcsAbstractHistorySession emptySession = new VcsAbstractHistorySession(Collections.emptyList()){

            @Nullable
            protected VcsRevisionNumber calcCurrentRevisionNumber() {
                try {
                    return GitHistoryUtils.getCurrentRevision(GitHistoryProvider.this.project, GitHistoryUtils.getLastCommitName(GitHistoryProvider.this.project, path));
                }
                catch (VcsException e) {
                    if (log.isDebugEnabled()) {
                        log.debug("Unable to retrieve the current revision number", (Throwable)e);
                    }
                    return null;
                }
            }

            public HistoryAsTreeProvider getHistoryAsTreeProvider() {
                return null;
            }
        };
        partner.reportCreatedEmptySession(emptySession);
        GitHistoryUtils.history(this.project, path, new Consumer<GitFileRevision>(){

            public void consume(GitFileRevision gitFileRevision) {
                partner.acceptRevision((VcsFileRevision)gitFileRevision);
            }
        }, new Consumer<VcsException>(){

            public void consume(VcsException e) {
                partner.reportException(e);
            }
        });
    }

    public boolean supportsHistoryForDirectories() {
        return false;
    }
}

