/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.commands.GitCommand;
import git4idea.commands.GitHandler;
import git4idea.commands.GitHandlerListener;
import git4idea.commands.GitHandlerUtil;
import git4idea.i18n.GitBundle;
import java.io.File;
import java.util.concurrent.Semaphore;
import org.jetbrains.annotations.NotNull;

public class GitSimpleHandler
extends GitHandler {
    private final StringBuilder myStderr;
    private final StringBuilder myStderrLine;
    private final StringBuilder myStdout;
    private final StringBuilder myStdoutLine;

    public GitSimpleHandler(@NotNull Project project, @NotNull File directory, @NotNull GitCommand command) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/commands/GitSimpleHandler.<init> must not be null");
        }
        if (directory == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of git4idea/commands/GitSimpleHandler.<init> must not be null");
        }
        if (command == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of git4idea/commands/GitSimpleHandler.<init> must not be null");
        }
        super(project, directory, command);
        this.myStderr = new StringBuilder();
        this.myStderrLine = new StringBuilder();
        this.myStdout = new StringBuilder();
        this.myStdoutLine = new StringBuilder();
    }

    public GitSimpleHandler(@NotNull Project project, @NotNull VirtualFile directory, @NotNull GitCommand command) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/commands/GitSimpleHandler.<init> must not be null");
        }
        if (directory == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of git4idea/commands/GitSimpleHandler.<init> must not be null");
        }
        if (command == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of git4idea/commands/GitSimpleHandler.<init> must not be null");
        }
        super(project, directory, command);
        this.myStderr = new StringBuilder();
        this.myStderrLine = new StringBuilder();
        this.myStdout = new StringBuilder();
        this.myStdoutLine = new StringBuilder();
    }

    @Override
    protected void processTerminated(int exitCode) {
        if (this.myVcs != null) {
            if (!this.isStdoutSuppressed() && this.myStdoutLine.length() != 0) {
                this.myVcs.showMessages(this.myStdoutLine.toString());
                this.myStdoutLine.setLength(0);
            } else if (!this.isStderrSuppressed() && this.myStderrLine.length() != 0) {
                this.myVcs.showErrorMessages(this.myStderrLine.toString());
                this.myStderrLine.setLength(0);
            }
        }
    }

    public void unsilence() {
        this.myVcs.showCommandLine(this.printableCommandLine());
        if (this.myStderr.length() != 0) {
            this.myVcs.showErrorMessages(this.myStderr.toString());
        }
        if (this.myStdout.length() != 0) {
            this.myVcs.showMessages(this.myStdout.toString());
        }
    }

    @Override
    protected void onTextAvailable(String text, Key outputType) {
        boolean suppressed;
        StringBuilder lineRest;
        StringBuilder entire;
        if (ProcessOutputTypes.STDOUT == outputType) {
            entire = this.myStdout;
            lineRest = this.myStdoutLine;
            suppressed = this.isStdoutSuppressed();
        } else if (ProcessOutputTypes.STDERR == outputType) {
            entire = this.myStderr;
            lineRest = this.myStderrLine;
            suppressed = this.isStderrSuppressed();
        } else {
            return;
        }
        entire.append(text);
        if (suppressed || this.myVcs == null) {
            return;
        }
        char last = lineRest.length() > 0 ? (char)lineRest.charAt(lineRest.length() - 1) : (char)'\uffffffff';
        int start = 0;
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (last == '\n' || last == '\r') {
                int savedPos = (ch == '\n' || ch == '\r') && ch != last ? i - 1 : i;
                if (last != '\r' || savedPos != i) {
                    String line;
                    if (lineRest.length() == 0) {
                        line = lineRest.append(text.substring(start, savedPos)).toString();
                        lineRest.setLength(0);
                    } else {
                        line = text.substring(start, savedPos);
                    }
                    if (ProcessOutputTypes.STDOUT == outputType) {
                        this.myVcs.showMessages(line);
                    } else if (ProcessOutputTypes.STDERR == outputType) {
                        this.myVcs.showErrorMessages(line);
                    }
                }
                start = savedPos;
            }
            last = ch;
        }
        if (start != text.length()) {
            lineRest.append(text.substring(start));
        }
    }

    public String getStderr() {
        return this.myStderr.toString();
    }

    public String getStdout() {
        return this.myStdout.toString();
    }

    public String run() throws VcsException {
        if (!this.isNoSSH()) {
            throw new IllegalStateException("Commands that require SSH could not be run using this method");
        }
        final VcsException[] ex = new VcsException[1];
        final String[] result = new String[1];
        final Semaphore sem = new Semaphore(0);
        this.addListener(new GitHandlerListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void processTerminated(int exitCode) {
                try {
                    if (exitCode == 0 || GitSimpleHandler.this.isIgnoredErrorCode(exitCode)) {
                        result[0] = GitSimpleHandler.this.getStdout();
                    } else {
                        String msg = GitSimpleHandler.this.getStderr();
                        if (msg.length() == 0) {
                            msg = GitSimpleHandler.this.getStdout();
                        }
                        if (msg.length() == 0) {
                            msg = GitBundle.message("git.error.exit", exitCode);
                        }
                        ex[0] = new VcsException(msg);
                    }
                }
                catch (Throwable t) {
                    ex[0] = new VcsException(t.toString(), t);
                }
                finally {
                    sem.release();
                }
            }

            @Override
            public void startFailed(Throwable exception) {
                ex[0] = new VcsException("Process failed to start (" + GitSimpleHandler.this.printableCommandLine() + "): " + exception.toString(), exception);
                sem.release();
            }
        });
        GitHandlerUtil.runInCurrentThread(this, null);
        try {
            sem.acquire();
        }
        catch (InterruptedException e) {
            throw new VcsException("The git process is interrupted: " + this.printableCommandLine(), (Throwable)e);
        }
        if (ex[0] != null) {
            throw ex[0];
        }
        if (result[0] == null) {
            throw new VcsException("The git command returned null: " + this.printableCommandLine());
        }
        return result[0];
    }
}

