/*
 * Decompiled with CFR 0.152.
 */
package git4idea.changes;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.CachingCommittedChangesProvider;
import com.intellij.openapi.vcs.ChangeListColumn;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.committed.DecoratorManager;
import com.intellij.openapi.vcs.changes.committed.VcsCommittedListsZipper;
import com.intellij.openapi.vcs.changes.committed.VcsCommittedViewAuxiliary;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.openapi.vcs.versionBrowser.ChangesBrowserSettingsEditor;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.AsynchConsumer;
import com.intellij.util.Consumer;
import git4idea.GitBranch;
import git4idea.GitRemote;
import git4idea.GitUtil;
import git4idea.changes.GitRepositoryLocation;
import git4idea.changes.GitVersionFilterComponent;
import git4idea.commands.GitSimpleHandler;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.Nullable;

public class GitCommittedChangeListProvider
implements CachingCommittedChangesProvider<CommittedChangeList, ChangeBrowserSettings> {
    private static final Logger LOG = Logger.getInstance((String)GitCommittedChangeListProvider.class.getName());
    private Project myProject;

    public GitCommittedChangeListProvider(Project project) {
        this.myProject = project;
    }

    public ChangeBrowserSettings createDefaultSettings() {
        return new ChangeBrowserSettings();
    }

    public ChangesBrowserSettingsEditor<ChangeBrowserSettings> createFilterUI(boolean showDateFilter) {
        return new GitVersionFilterComponent(showDateFilter);
    }

    public RepositoryLocation getLocationFor(FilePath root) {
        VirtualFile gitRoot = GitUtil.getGitRootOrNull(root);
        if (gitRoot == null) {
            return null;
        }
        try {
            GitBranch c = GitBranch.current(this.myProject, gitRoot);
            if (c == null) {
                return null;
            }
            String remote = c.getTrackedRemoteName(this.myProject, gitRoot);
            if (StringUtil.isEmpty((String)remote)) {
                return null;
            }
            File rootFile = new File(gitRoot.getPath());
            if (".".equals(remote)) {
                return new GitRepositoryLocation(gitRoot.getUrl(), rootFile);
            }
            GitRemote r = GitRemote.find(this.myProject, gitRoot, remote);
            return r == null ? null : new GitRepositoryLocation(r.fetchUrl(), rootFile);
        }
        catch (VcsException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Exception for determining repository location", (Throwable)e);
            }
            return null;
        }
    }

    public RepositoryLocation getLocationFor(FilePath root, String repositoryPath) {
        return this.getLocationFor(root);
    }

    public VcsCommittedListsZipper getZipper() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadCommittedChanges(ChangeBrowserSettings settings, RepositoryLocation location, int maxCount, AsynchConsumer<CommittedChangeList> consumer) throws VcsException {
        try {
            this.getCommittedChangesImpl(settings, location, maxCount, (Consumer<CommittedChangeList>)consumer);
        }
        finally {
            consumer.finished();
        }
    }

    public List<CommittedChangeList> getCommittedChanges(ChangeBrowserSettings settings, RepositoryLocation location, int maxCount) throws VcsException {
        final ArrayList<CommittedChangeList> result = new ArrayList<CommittedChangeList>();
        this.getCommittedChangesImpl(settings, location, maxCount, new Consumer<CommittedChangeList>(){

            public void consume(CommittedChangeList committedChangeList) {
                result.add(committedChangeList);
            }
        });
        return result;
    }

    private void getCommittedChangesImpl(ChangeBrowserSettings settings, RepositoryLocation location, final int maxCount, Consumer<CommittedChangeList> consumer) throws VcsException {
        GitRepositoryLocation l = (GitRepositoryLocation)location;
        final Long beforeRev = settings.getChangeBeforeFilter();
        final Long afterRev = settings.getChangeBeforeFilter();
        final Date beforeDate = settings.getDateBeforeFilter();
        final Date afterDate = settings.getDateBeforeFilter();
        final String author = settings.getUserFilter();
        VirtualFile root = LocalFileSystem.getInstance().findFileByIoFile(l.getRoot());
        if (root == null) {
            throw new VcsException("The repository does not exists anymore: " + l.getRoot());
        }
        GitUtil.getLocalCommittedChanges(this.myProject, root, new Consumer<GitSimpleHandler>(){

            public void consume(GitSimpleHandler h) {
                if (!StringUtil.isEmpty((String)author)) {
                    h.addParameters("--author=" + author);
                }
                if (beforeDate != null) {
                    h.addParameters("--before=" + GitUtil.gitTime(beforeDate));
                }
                if (afterDate != null) {
                    h.addParameters("--after=" + GitUtil.gitTime(afterDate));
                }
                if (maxCount != GitCommittedChangeListProvider.this.getUnlimitedCountValue()) {
                    h.addParameters("-n" + maxCount);
                }
                if (beforeRev != null && afterRev != null) {
                    h.addParameters(GitUtil.formatLongRev(afterRev) + ".." + GitUtil.formatLongRev(beforeRev));
                } else if (beforeRev != null) {
                    h.addParameters(GitUtil.formatLongRev(beforeRev));
                } else if (afterRev != null) {
                    h.addParameters(GitUtil.formatLongRev(afterRev) + "..");
                }
            }
        }, consumer);
    }

    public ChangeListColumn[] getColumns() {
        return new ChangeListColumn[]{ChangeListColumn.NUMBER, ChangeListColumn.DATE, ChangeListColumn.DESCRIPTION, ChangeListColumn.NAME};
    }

    public VcsCommittedViewAuxiliary createActions(DecoratorManager manager, RepositoryLocation location) {
        return null;
    }

    public int getUnlimitedCountValue() {
        return -1;
    }

    public int getFormatVersion() {
        return 0;
    }

    public void writeChangeList(DataOutput stream, CommittedChangeList list) throws IOException {
    }

    public CommittedChangeList readChangeList(RepositoryLocation location, DataInput stream) throws IOException {
        return null;
    }

    public boolean isMaxCountSupported() {
        return false;
    }

    public Collection<FilePath> getIncomingFiles(RepositoryLocation location) throws VcsException {
        return null;
    }

    public boolean refreshCacheByNumber() {
        return false;
    }

    @Nls
    public String getChangelistTitle() {
        return null;
    }

    public boolean isChangeLocallyAvailable(FilePath filePath, @Nullable VcsRevisionNumber localRevision, VcsRevisionNumber changeRevision, CommittedChangeList changeList) {
        return false;
    }

    public boolean refreshIncomingWithCommitted() {
        return false;
    }
}

