/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.commands.GitCommand;
import git4idea.commands.GitHandlerUtil;
import git4idea.commands.GitLineHandler;
import git4idea.i18n.GitBundle;
import git4idea.ui.GitUIUtil;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class GitInit
extends DumbAwareAction {
    public void actionPerformed(AnActionEvent e) {
        final Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        FileChooserDescriptor fcd = new FileChooserDescriptor(false, true, false, false, false, false);
        fcd.setShowFileSystemRoots(true);
        fcd.setTitle(GitBundle.getString("init.destination.directory.title"));
        fcd.setDescription(GitBundle.getString("init.destination.directory.description"));
        fcd.setHideIgnored(false);
        final VirtualFile baseDir = project.getBaseDir();
        VirtualFile[] files = FileChooser.chooseFiles((Project)project, (FileChooserDescriptor)fcd, (VirtualFile)baseDir);
        if (files.length == 0) {
            return;
        }
        final VirtualFile root = files[0];
        if (GitUtil.isUnderGit(root)) {
            Messages.showErrorDialog((Project)project, (String)GitBundle.message("init.error.already.under.git", root.getPresentableUrl()), (String)GitBundle.getString("init.error.title"));
            return;
        }
        GitLineHandler h = new GitLineHandler(project, root, GitCommand.INIT);
        h.setNoSSH(true);
        GitHandlerUtil.doSynchronously(h, GitBundle.getString("initializing.title"), h.printableCommandLine());
        if (!h.errors().isEmpty()) {
            GitUIUtil.showOperationErrors(project, h.errors(), "git init");
            return;
        }
        int rc = Messages.showYesNoDialog((Project)project, (String)GitBundle.getString("init.add.root.message"), (String)GitBundle.getString("init.add.root.title"), (Icon)Messages.getQuestionIcon());
        if (rc != 0) {
            return;
        }
        GitVcs.getInstance(project).runInBackground(new Task.Backgroundable(project, GitBundle.getString("common.refreshing")){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/actions/GitInit$1.run must not be null");
                }
                root.refresh(false, false);
                String path = root.equals(baseDir) ? "" : root.getPath();
                ProjectLevelVcsManager vcs = ProjectLevelVcsManager.getInstance((Project)project);
                ArrayList<VcsDirectoryMapping> vcsDirectoryMappings = new ArrayList<VcsDirectoryMapping>(vcs.getDirectoryMappings());
                VcsDirectoryMapping mapping = new VcsDirectoryMapping(path, GitVcs.getInstance(project).getName());
                for (int i = 0; i < vcsDirectoryMappings.size(); ++i) {
                    VcsDirectoryMapping m = (VcsDirectoryMapping)vcsDirectoryMappings.get(i);
                    if (!m.getDirectory().equals(path)) continue;
                    if (m.getVcs().length() == 0) {
                        vcsDirectoryMappings.set(i, mapping);
                        mapping = null;
                        break;
                    }
                    if (!m.getVcs().equals(mapping.getVcs())) continue;
                    mapping = null;
                    break;
                }
                if (mapping != null) {
                    vcsDirectoryMappings.add(mapping);
                }
                vcs.setDirectoryMappings(vcsDirectoryMappings);
                vcs.updateActiveVcss();
                GitUtil.refreshFiles(project, Collections.singleton(root));
            }
        });
    }

    public void update(AnActionEvent e) {
        Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        Presentation presentation = e.getPresentation();
        if (project == null) {
            presentation.setEnabled(false);
            presentation.setVisible(false);
            return;
        }
        presentation.setEnabled(true);
        presentation.setVisible(true);
    }
}

