/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XmlSchemaProvider {
    public static final ExtensionPointName<XmlSchemaProvider> EP_NAME = new ExtensionPointName("com.intellij.xml.schemaProvider");

    @Nullable
    public static XmlFile findSchema(@NotNull @NonNls String namespace, @Nullable Module module, @NotNull PsiFile file) {
        if (namespace == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xml/XmlSchemaProvider.findSchema must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/xml/XmlSchemaProvider.findSchema must not be null");
        }
        boolean dumb = DumbService.getInstance(file.getProject()).isDumb();
        for (XmlSchemaProvider provider : (XmlSchemaProvider[])Extensions.getExtensions(EP_NAME)) {
            XmlFile schema;
            if (dumb && !(provider instanceof DumbAware) || file instanceof XmlFile && !provider.isAvailable((XmlFile)file) || (schema = provider.getSchema(namespace, module, file)) == null) continue;
            return schema;
        }
        return null;
    }

    @Nullable
    public static XmlFile findSchema(@NotNull @NonNls String namespace, @NotNull PsiFile baseFile) {
        if (namespace == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xml/XmlSchemaProvider.findSchema must not be null");
        }
        if (baseFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/xml/XmlSchemaProvider.findSchema must not be null");
        }
        PsiDirectory directory = baseFile.getParent();
        Module module = ModuleUtil.findModuleForPsiElement(directory == null ? baseFile : directory);
        return XmlSchemaProvider.findSchema(namespace, module, baseFile);
    }

    @Deprecated
    @Nullable
    public static XmlSchemaProvider getAvailableProvider(@NotNull XmlFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xml/XmlSchemaProvider.getAvailableProvider must not be null");
        }
        for (XmlSchemaProvider provider : (XmlSchemaProvider[])Extensions.getExtensions(EP_NAME)) {
            if (!provider.isAvailable(file)) continue;
            return provider;
        }
        return null;
    }

    public static List<XmlSchemaProvider> getAvailableProviders(final @NotNull XmlFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xml/XmlSchemaProvider.getAvailableProviders must not be null");
        }
        return ContainerUtil.findAll((Object[])Extensions.getExtensions(EP_NAME), (Condition)new Condition<XmlSchemaProvider>(){

            public boolean value(XmlSchemaProvider xmlSchemaProvider) {
                return xmlSchemaProvider.isAvailable(file);
            }
        });
    }

    @Nullable
    public abstract XmlFile getSchema(@NotNull @NonNls String var1, @Nullable Module var2, @NotNull PsiFile var3);

    public boolean isAvailable(@NotNull XmlFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xml/XmlSchemaProvider.isAvailable must not be null");
        }
        return false;
    }

    @NotNull
    public Set<String> getAvailableNamespaces(@NotNull XmlFile file, @Nullable String tagName) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xml/XmlSchemaProvider.getAvailableNamespaces must not be null");
        }
        Set<String> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException("@NotNull method com/intellij/xml/XmlSchemaProvider.getAvailableNamespaces must not return null");
        }
        return set;
    }

    @Nullable
    public String getDefaultPrefix(@NotNull @NonNls String namespace, @NotNull XmlFile context) {
        if (namespace == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xml/XmlSchemaProvider.getDefaultPrefix must not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/xml/XmlSchemaProvider.getDefaultPrefix must not be null");
        }
        return null;
    }

    @Nullable
    public Set<String> getLocations(@NotNull @NonNls String namespace, @NotNull XmlFile context) {
        if (namespace == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xml/XmlSchemaProvider.getLocations must not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/xml/XmlSchemaProvider.getLocations must not be null");
        }
        return null;
    }
}

