/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.ElementPresentationManager;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.SubTag;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ResolvingConverter<T>
extends Converter<T> {
    @Deprecated
    public static final ResolvingConverter EMPTY_CONVERTER = new ResolvingConverter(){

        @NotNull
        public Collection getVariants(ConvertContext context) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException("@NotNull method com/intellij/util/xml/ResolvingConverter$1.getVariants must not return null");
            }
            return list;
        }

        @Override
        public Object fromString(String s, ConvertContext context) {
            return s;
        }

        @Override
        public String toString(Object t, ConvertContext context) {
            return String.valueOf(t);
        }
    };
    @Deprecated
    public static final Converter<Boolean> BOOLEAN_CONVERTER = new ResolvingConverter<Boolean>(){

        @Override
        public Boolean fromString(String s, ConvertContext context) {
            if ("true".equalsIgnoreCase(s)) {
                return Boolean.TRUE;
            }
            if ("false".equalsIgnoreCase(s)) {
                return Boolean.FALSE;
            }
            return null;
        }

        @Override
        public String toString(Boolean t, ConvertContext context) {
            return t == null ? null : t.toString();
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        public Collection<? extends Boolean> getVariants(ConvertContext context) {
            List<Object> list;
            SubTag annotation;
            DomElement element = context.getInvocationElement();
            if (element instanceof GenericDomValue && (annotation = element.getAnnotation(SubTag.class)) != null && annotation.indicator()) {
                list = Collections.emptyList();
                if (list == null) throw new IllegalStateException("@NotNull method com/intellij/util/xml/ResolvingConverter$2.getVariants must not return null");
                return list;
            }
            list = Arrays.asList(Boolean.FALSE, Boolean.TRUE);
            if (list != null) return list;
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/ResolvingConverter$2.getVariants must not return null");
        }
    };

    @Override
    public String getErrorMessage(@Nullable String s, ConvertContext context) {
        return CodeInsightBundle.message("error.cannot.resolve.default.message", s);
    }

    @NotNull
    public abstract Collection<? extends T> getVariants(ConvertContext var1);

    @Deprecated
    @NotNull
    public Set<String> getAdditionalVariants() {
        Set<String> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/ResolvingConverter.getAdditionalVariants must not return null");
        }
        return set;
    }

    @NotNull
    public Set<String> getAdditionalVariants(@NotNull ConvertContext context) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/ResolvingConverter.getAdditionalVariants must not be null");
        }
        Set<String> set = this.getAdditionalVariants();
        if (set == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/ResolvingConverter.getAdditionalVariants must not return null");
        }
        return set;
    }

    public void handleElementRename(GenericDomValue<T> genericValue, ConvertContext context, String newElementName) {
        genericValue.setStringValue(newElementName);
    }

    public void bindReference(GenericDomValue<T> genericValue, ConvertContext context, PsiElement newTarget) {
        DomElement domElement;
        if (newTarget instanceof XmlTag && (domElement = genericValue.getManager().getDomElement((XmlTag)newTarget)) != null) {
            genericValue.setStringValue(ElementPresentationManager.getElementName(domElement));
        }
    }

    @Nullable
    public PsiElement getPsiElement(@Nullable T resolvedValue) {
        if (resolvedValue instanceof PsiElement) {
            return (PsiElement)resolvedValue;
        }
        if (resolvedValue instanceof DomElement) {
            return ((DomElement)resolvedValue).getXmlElement();
        }
        return null;
    }

    public boolean isReferenceTo(@NotNull PsiElement element, String stringValue, @Nullable T resolveResult, ConvertContext context) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/ResolvingConverter.isReferenceTo must not be null");
        }
        return resolveResult != null && element.getManager().areElementsEquivalent(element, this.getPsiElement(resolveResult));
    }

    @Nullable
    public PsiElement resolve(T o, ConvertContext context) {
        PsiElement psiElement = this.getPsiElement(o);
        return psiElement == null && o != null ? DomUtil.getValueElement((GenericDomValue)context.getInvocationElement()) : psiElement;
    }

    public LocalQuickFix[] getQuickFixes(ConvertContext context) {
        return LocalQuickFix.EMPTY_ARRAY;
    }

    @Nullable
    public LookupElement createLookupElement(T t) {
        return null;
    }

    public static abstract class WrappedResolvingConverter<T>
    extends ResolvingConverter<T> {
        private final Converter<T> myWrappedConverter;

        public WrappedResolvingConverter(Converter<T> converter) {
            this.myWrappedConverter = converter;
        }

        @Override
        public T fromString(String s, ConvertContext context) {
            return this.myWrappedConverter.fromString(s, context);
        }

        @Override
        public String toString(T t, ConvertContext context) {
            return this.myWrappedConverter.toString(t, context);
        }
    }

    public static abstract class StringConverter
    extends ResolvingConverter<String> {
        @Override
        public String fromString(String s, ConvertContext context) {
            return s;
        }

        @Override
        public String toString(String s, ConvertContext context) {
            return s;
        }
    }
}

