/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.ui.Timer;
import javax.swing.SwingUtilities;

public abstract class Animator
implements Disposable {
    private int myTotalFrames;
    private int myCycleLength;
    private final Timer myTimer;
    private int myCurrentFrame;
    private int myQueuedFrames = 0;
    private final boolean myRepeatable;
    private int myRepeatCount;
    private boolean myLastAnimated;
    private boolean myForward = true;

    public Animator(String name, int totalFrames, int cycleLength, boolean repeatable, int interCycleGap, int maxRepeatCount) {
        this(name, totalFrames, cycleLength, repeatable, interCycleGap, maxRepeatCount, true);
    }

    public Animator(String name, int totalFrames, int cycleLength, boolean repeatable, final int interCycleGap, final int maxRepeatCount, boolean forward) {
        this.myTotalFrames = totalFrames;
        this.myCycleLength = cycleLength;
        this.myRepeatable = repeatable;
        this.myForward = forward;
        this.myCurrentFrame = forward ? 0 : totalFrames;
        Application application = ApplicationManager.getApplication();
        this.myTimer = application == null || application.isUnitTestMode() ? null : new Timer(name, this.myCycleLength / this.myTotalFrames){

            @Override
            protected void onTimer() throws InterruptedException {
                boolean repaint = true;
                if (!Animator.this.isAnimated()) {
                    if (Animator.this.myLastAnimated) {
                        Animator.this.myCurrentFrame = Animator.this.myForward ? 0 : Animator.this.myTotalFrames;
                        Animator.this.myQueuedFrames = 0;
                        Animator.this.myLastAnimated = false;
                    } else {
                        repaint = false;
                    }
                } else {
                    boolean toNextFrame;
                    Animator.this.myLastAnimated = true;
                    if (Animator.this.myQueuedFrames > Animator.this.myTotalFrames) {
                        return;
                    }
                    boolean bl = Animator.this.myForward ? Animator.this.myCurrentFrame + 1 < Animator.this.myTotalFrames : (toNextFrame = Animator.this.myCurrentFrame - 1 >= 0);
                    if (toNextFrame && Animator.this.myForward) {
                        Animator.this.myCurrentFrame++;
                    } else if (toNextFrame && !Animator.this.myForward) {
                        Animator.this.myCurrentFrame--;
                    } else if (Animator.this.myRepeatable) {
                        if (maxRepeatCount == -1 || Animator.this.myRepeatCount < maxRepeatCount) {
                            Animator.this.myRepeatCount++;
                            Animator.this.myCurrentFrame = 0;
                            if (interCycleGap > 0) {
                                Thread.sleep(interCycleGap - this.getSpan());
                            }
                        } else {
                            repaint = false;
                            this.suspend();
                            Animator.this.myRepeatCount = 0;
                            Animator.this.cycleEnd();
                        }
                    } else {
                        repaint = false;
                        this.suspend();
                        Animator.this.cycleEnd();
                    }
                }
                if (repaint) {
                    Animator.this.myQueuedFrames++;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Animator.this.myQueuedFrames--;
                            Animator.this.paintNow(Animator.this.myCurrentFrame, Animator.this.myTotalFrames, Animator.this.myCycleLength);
                        }
                    });
                }
            }
        };
    }

    private void cycleEnd() throws InterruptedException {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Animator.this.paintCycleEnd();
            }
        });
        this.onAnimationMaxCycleReached();
    }

    protected void paintCycleEnd() {
    }

    protected void onAnimationMaxCycleReached() throws InterruptedException {
    }

    public void suspend() {
        if (this.myTimer != null) {
            this.myTimer.suspend();
        }
    }

    public void resume() {
        if (this.myTimer != null) {
            this.myTimer.resume();
        }
    }

    public void setTakInitialDelay(boolean take) {
        if (this.myTimer != null) {
            this.myTimer.setTakeInitialDelay(take);
        }
    }

    public abstract void paintNow(float var1, float var2, float var3);

    public void dispose() {
        if (this.myTimer != null) {
            this.myTimer.dispose();
        }
    }

    public boolean isRunning() {
        return this.myTimer != null && this.myTimer.isRunning() && this.myLastAnimated;
    }

    public boolean isAnimated() {
        return true;
    }

    public void reset() {
        this.myCurrentFrame = 0;
        this.myRepeatCount = 0;
    }

    public final boolean isForward() {
        return this.myForward;
    }

    public boolean isDisposed() {
        return this.myTimer == null || this.myTimer.isDisposed();
    }
}

