/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.LogicalRoot;
import com.intellij.util.LogicalRootType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VirtualFileLogicalRoot
extends LogicalRoot {
    private VirtualFile myVirtualFile;
    private LogicalRootType myType;

    public VirtualFileLogicalRoot(VirtualFile virtualFile, LogicalRootType type) {
        this.myVirtualFile = virtualFile;
        this.myType = type;
    }

    public VirtualFileLogicalRoot(VirtualFile virtualFile) {
        this(virtualFile, LogicalRootType.SOURCE_ROOT);
    }

    @Override
    @Nullable
    public VirtualFile getVirtualFile() {
        return this.myVirtualFile;
    }

    @Override
    @NotNull
    public LogicalRootType getType() {
        LogicalRootType logicalRootType = this.myType;
        if (logicalRootType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/VirtualFileLogicalRoot.getType must not return null");
        }
        return logicalRootType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VirtualFileLogicalRoot that = (VirtualFileLogicalRoot)o;
        return this.myVirtualFile.equals(that.myVirtualFile);
    }

    public int hashCode() {
        return this.myVirtualFile.hashCode();
    }
}

