/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.impl.table;

import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.ui.tabs.impl.LayoutPassInfo;
import com.intellij.ui.tabs.impl.table.TableRow;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TablePassInfo
extends LayoutPassInfo {
    List<TableRow> table = new ArrayList<TableRow>();
    public Rectangle toFitRec;
    Map<TabInfo, TableRow> myInfo2Row = new HashMap<TabInfo, TableRow>();
    int requiredWidth;
    int requiredRows;
    int rowToFitMaxX;
    JBTabsImpl myTabs;

    TablePassInfo(JBTabsImpl tabs) {
        this.myTabs = tabs;
    }

    @Override
    public TabInfo getPreviousFor(TabInfo info) {
        TableRow row = this.myInfo2Row.get(info);
        return this.getPrevious(row.myColumns, row.myColumns.indexOf(info));
    }

    @Override
    public TabInfo getNextFor(TabInfo info) {
        TableRow row = this.myInfo2Row.get(info);
        return this.getNext(row.myColumns, row.myColumns.indexOf(info));
    }

    public boolean isInSelectionRow(TabInfo tabInfo) {
        TableRow row = this.myInfo2Row.get(tabInfo);
        int index = this.table.indexOf(row);
        return index != -1 && index == this.table.size() - 1;
    }

    @Override
    public int getRowCount() {
        return this.table.size();
    }

    @Override
    public int getColumnCount(int row) {
        return this.table.get((int)row).myColumns.size();
    }

    @Override
    public TabInfo getTabAt(int row, int column) {
        return this.table.get((int)row).myColumns.get(column);
    }

    @Override
    public boolean hasCurveSpaceFor(TabInfo tabInfo) {
        TableRow row = this.myInfo2Row.get(tabInfo);
        return row.myColumns.indexOf(tabInfo) < row.myColumns.size() - 1;
    }

    @Override
    public Rectangle getHeaderRectangle() {
        return (Rectangle)this.toFitRec.clone();
    }
}

