/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components.panels;

import com.intellij.openapi.ui.NullableComponent;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class Wrapper
extends JPanel
implements NullableComponent {
    public Wrapper() {
        this.setLayout(new BorderLayout());
    }

    public Wrapper(JComponent wrapped) {
        this.setLayout(new BorderLayout());
        this.add((Component)wrapped, "Center");
    }

    public Wrapper(LayoutManager layout, JComponent wrapped) {
        super(layout);
        this.add(wrapped);
    }

    public Wrapper(boolean isDoubleBuffered) {
        super(isDoubleBuffered);
    }

    public Wrapper(LayoutManager layout) {
        super(layout);
    }

    public Wrapper(LayoutManager layout, boolean isDoubleBuffered) {
        super(layout, isDoubleBuffered);
    }

    public void setContent(JComponent wrapped) {
        if (wrapped == this.getTargetComponent()) {
            return;
        }
        this.removeAll();
        this.setLayout(new BorderLayout());
        if (wrapped != null) {
            this.add((Component)wrapped, "Center");
        }
        this.validate();
    }

    public boolean isNull() {
        return this.getComponentCount() == 0;
    }

    @Override
    public void requestFocus() {
        if (this.getTargetComponent() == this) {
            super.requestFocus();
            return;
        }
        this.getTargetComponent().requestFocus();
    }

    @Override
    public boolean requestFocusInWindow() {
        if (this.getTargetComponent() == this) {
            return super.requestFocusInWindow();
        }
        return this.getTargetComponent().requestFocusInWindow();
    }

    public void requestFocusInternal() {
        super.requestFocus();
    }

    @Override
    public final boolean requestFocus(boolean temporary) {
        if (this.getTargetComponent() == this) {
            return super.requestFocus(temporary);
        }
        return this.getTargetComponent().requestFocus(temporary);
    }

    public JComponent getTargetComponent() {
        if (this.getComponentCount() == 1) {
            return (JComponent)this.getComponent(0);
        }
        return this;
    }

    public static class North
    extends Wrapper {
        public North(JComponent wrapped) {
            super(new BorderLayout());
            this.add((Component)wrapped, "North");
        }
    }

    public static class FocusHolder
    extends Wrapper
    implements FocusListener {
        private Runnable myFocusGainedCallback;

        public FocusHolder() {
            this.init();
        }

        public FocusHolder(JComponent wrapped) {
            super(wrapped);
            this.init();
        }

        public FocusHolder(LayoutManager layout, JComponent wrapped) {
            super(layout, wrapped);
            this.init();
        }

        public FocusHolder(boolean isDoubleBuffered) {
            super(isDoubleBuffered);
            this.init();
        }

        public FocusHolder(LayoutManager layout) {
            super(layout);
            this.init();
        }

        public FocusHolder(LayoutManager layout, boolean isDoubleBuffered) {
            super(layout, isDoubleBuffered);
            this.init();
        }

        private void init() {
            UIUtil.setFocusProxy((JComponent)this, (boolean)true);
            this.setFocusable(true);
            this.addFocusListener(this);
        }

        public void requestFocus(Runnable callback) {
            this.myFocusGainedCallback = callback;
            if (this.isFocusOwner()) {
                this.processCallback();
            } else {
                this.requestFocusInternal();
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.processCallback();
        }

        private void processCallback() {
            if (this.myFocusGainedCallback != null) {
                Runnable callback = this.myFocusGainedCallback;
                this.myFocusGainedCallback = null;
                callback.run();
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
        }
    }
}

