/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.StatusBar;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nullable;

public class StatusBarInformer {
    private String myText;
    private StatusBar myStatusBar;
    private JComponent myComponent;

    public StatusBarInformer(JComponent component, String text) {
        this(component, text, null);
    }

    public StatusBarInformer(JComponent component, String text, StatusBar statusBar) {
        this.myText = text;
        this.myStatusBar = statusBar;
        this.myComponent = component;
        this.myComponent.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                StatusBar bar = StatusBarInformer.this.getStatusBar();
                String text = StatusBarInformer.this.getText();
                if (bar != null) {
                    bar.setInfo(text);
                }
                StatusBarInformer.this.myComponent.setToolTipText(text);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                StatusBar bar = StatusBarInformer.this.getStatusBar();
                if (bar != null) {
                    bar.setInfo(null);
                }
                StatusBarInformer.this.myComponent.setToolTipText(null);
            }
        });
    }

    @Nullable
    protected String getText() {
        return this.myText;
    }

    @Nullable
    protected StatusBar getStatusBar() {
        if (this.myStatusBar != null) {
            return this.myStatusBar;
        }
        Window window = SwingUtilities.getWindowAncestor(this.myComponent);
        if (window instanceof IdeFrame) {
            return ((IdeFrame)((Object)window)).getStatusBar();
        }
        return null;
    }
}

