/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.ui.HighlightableComponent;
import com.intellij.ui.HighlightedText;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class HyperlinkLabel
extends HighlightableComponent {
    private HighlightedText myHighlightedText;
    private final List<HyperlinkListener> myListeners = new ArrayList<HyperlinkListener>();
    private final Color myTextForegroundColor;
    private final Color myTextBackgroundColor;
    private final Color myTextEffectColor;

    public HyperlinkLabel() {
        this("");
    }

    public HyperlinkLabel(String text) {
        this(text, Color.BLUE, UIUtil.getLabelBackground(), Color.BLUE);
    }

    public HyperlinkLabel(String text, Color textForegroundColor, Color textBackgroundColor, Color textEffectColor) {
        this.myTextForegroundColor = textForegroundColor;
        this.myTextBackgroundColor = textBackgroundColor;
        this.myTextEffectColor = textEffectColor;
        this.enforceBackgroundOutsideText(textBackgroundColor);
        this.setHyperlinkText(text);
        this.enableEvents(16L);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.adjustSize();
    }

    public void setHyperlinkText(String text) {
        this.prepareText(text, this.myTextForegroundColor, this.myTextBackgroundColor, this.myTextEffectColor);
        this.revalidate();
        this.adjustSize();
    }

    private void adjustSize() {
        Dimension preferredSize = this.getPreferredSize();
        this.setMinimumSize(preferredSize);
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        if (e.getID() == 504) {
            this.setCursor(Cursor.getPredefinedCursor(12));
        } else if (e.getID() == 505) {
            this.setCursor(Cursor.getDefaultCursor());
        } else if (UIUtil.isActionClick((MouseEvent)e, (int)501)) {
            this.fireHyperlinkEvent();
        }
        super.processMouseEvent(e);
    }

    private void prepareText(String text, Color textForegroundColor, Color textBackgroundColor, Color textEffectColor) {
        this.setFont(UIUtil.getLabelFont());
        this.myHighlightedText = new HighlightedText();
        this.myHighlightedText.appendText(text, new TextAttributes(textForegroundColor, textBackgroundColor, textEffectColor, EffectType.LINE_UNDERSCORE, 0));
        this.myHighlightedText.applyToComponent(this);
        this.adjustSize();
    }

    public void addHyperlinkListener(HyperlinkListener listener) {
        this.myListeners.add(listener);
    }

    public void removeHyperlinkListener(HyperlinkListener listener) {
        this.myListeners.remove(listener);
    }

    String getText() {
        return this.myHighlightedText.getText();
    }

    protected void fireHyperlinkEvent() {
        HyperlinkListener[] listeners;
        HyperlinkEvent e = new HyperlinkEvent(this, HyperlinkEvent.EventType.ACTIVATED, null, null);
        for (HyperlinkListener listener : listeners = this.myListeners.toArray(new HyperlinkListener[this.myListeners.size()])) {
            listener.hyperlinkUpdate(e);
        }
    }
}

