/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.Border;

public class EdgeBorder
implements Border {
    public static final int EDGE_RIGHT = 61440;
    public static final int EDGE_BOTTOM = 3840;
    public static final int EDGE_LEFT = 240;
    public static final int EDGE_TOP = 15;
    public static final int EDGE_ALL = 65535;
    private final Insets myInsets = new Insets(2, 2, 2, 2);
    private final int b;

    public EdgeBorder(int i) {
        this.b = i;
        this.recalcInsets();
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    @Override
    public Insets getBorderInsets(Component component) {
        return this.myInsets;
    }

    @Override
    public void paintBorder(Component component, Graphics g, int x, int y, int width, int height) {
        Color color = UIUtil.getSeparatorShadow();
        Color color1 = UIUtil.getSeparatorHighlight();
        Color color2 = g.getColor();
        if ((this.b & 0xF) != 0) {
            g.setColor(color);
            UIUtil.drawLine((Graphics)g, (int)x, (int)y, (int)(x + width - 1), (int)y);
            g.setColor(color1);
            UIUtil.drawLine((Graphics)g, (int)x, (int)(y + 1), (int)(x + width - 1), (int)(y + 1));
        }
        if ((this.b & 0xF0) != 0) {
            g.setColor(color);
            UIUtil.drawLine((Graphics)g, (int)x, (int)y, (int)x, (int)(y + height - 1));
            g.setColor(color1);
            UIUtil.drawLine((Graphics)g, (int)(x + 1), (int)y, (int)(x + 1), (int)(y + height - 1));
        }
        if ((this.b & 0xF00) != 0) {
            g.setColor(color);
            UIUtil.drawLine((Graphics)g, (int)x, (int)(y + height - 2), (int)(x + width - 1), (int)(y + height - 2));
            g.setColor(color1);
            UIUtil.drawLine((Graphics)g, (int)x, (int)(y + height - 1), (int)(x + width - 1), (int)(y + height - 1));
        }
        if ((this.b & 0xF000) != 0) {
            g.setColor(color1);
            UIUtil.drawLine((Graphics)g, (int)(x + width + 1), (int)y, (int)(x + width + 1), (int)(y + height - 1));
            g.setColor(color);
            UIUtil.drawLine((Graphics)g, (int)(x + width), (int)y, (int)(x + width), (int)(y + height - 1));
        }
        g.setColor(color2);
    }

    protected void recalcInsets() {
        this.myInsets.top = (this.b & 0xF) == 0 ? 0 : 2;
        this.myInsets.left = (this.b & 0xF0) == 0 ? 0 : 2;
        this.myInsets.bottom = (this.b & 0xF00) == 0 ? 0 : 2;
        this.myInsets.right = (this.b & 0xF000) == 0 ? 0 : 2;
    }
}

