/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.semantic;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.semantic.SemElement;
import com.intellij.semantic.SemKey;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SemService {
    public static SemService getSemService(Project p) {
        return ServiceManager.getService(p, SemService.class);
    }

    @Nullable
    public <T extends SemElement> T getSemElement(SemKey<T> key, @NotNull PsiElement psi) {
        if (psi == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/semantic/SemService.getSemElement must not be null");
        }
        List<T> list = this.getSemElements(key, psi);
        if (list.isEmpty()) {
            return null;
        }
        return (T)((SemElement)list.get(0));
    }

    public abstract <T extends SemElement> List<T> getSemElements(SemKey<T> var1, @NotNull PsiElement var2);

    @Nullable
    public abstract <T extends SemElement> List<T> getCachedSemElements(SemKey<T> var1, @NotNull PsiElement var2);

    public abstract <T extends SemElement> void setCachedSemElement(SemKey<T> var1, @NotNull PsiElement var2, @Nullable T var3);

    public abstract <T extends SemElement> void clearCachedSemElements(@NotNull PsiElement var1);

    public abstract void clearCache();

    public abstract void performAtomicChange(@NotNull Runnable var1);

    public abstract boolean isInsideAtomicChange();
}

