/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.DifferenceFilter;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.codeStyle.AppCodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CodeStyleSchemes;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.ProjectCodeStyleSettingsManager;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class CodeStyleSettingsManager
implements PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance((String)("#" + CodeStyleSettingsManager.class.getName()));
    public CodeStyleSettings PER_PROJECT_SETTINGS = null;
    public boolean USE_PER_PROJECT_SETTINGS = false;
    private CodeStyleSettings myTemporarySettings;

    public static CodeStyleSettingsManager getInstance(Project project) {
        return ServiceManager.getService(project, ProjectCodeStyleSettingsManager.class);
    }

    public static CodeStyleSettingsManager getInstance() {
        return ServiceManager.getService(AppCodeStyleSettingsManager.class);
    }

    public CodeStyleSettingsManager(Project project) {
    }

    public CodeStyleSettingsManager() {
    }

    public static CodeStyleSettings getSettings(Project project) {
        CodeStyleSettingsManager instance = project == null ? CodeStyleSettingsManager.getInstance() : CodeStyleSettingsManager.getInstance(project);
        return instance.getCurrentSettings();
    }

    public CodeStyleSettings getCurrentSettings() {
        if (this.myTemporarySettings != null) {
            return this.myTemporarySettings;
        }
        if (this.USE_PER_PROJECT_SETTINGS && this.PER_PROJECT_SETTINGS != null) {
            return this.PER_PROJECT_SETTINGS;
        }
        return CodeStyleSchemes.getInstance().getCurrentScheme().getCodeStyleSettings();
    }

    public void readExternal(Element element) throws InvalidDataException {
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element, (DefaultJDOMExternalizer.JDOMFilter)new DifferenceFilter((Object)this, (Object)new CodeStyleSettingsManager()));
    }

    @Override
    public Element getState() {
        Element result = new Element("state");
        try {
            this.writeExternal(result);
        }
        catch (WriteExternalException e) {
            LOG.error((Throwable)e);
        }
        return result;
    }

    @Override
    public void loadState(Element state) {
        try {
            this.readExternal(state);
        }
        catch (InvalidDataException e) {
            LOG.error((Throwable)e);
        }
    }

    public void disposeComponent() {
    }

    public void initComponent() {
    }

    public void projectOpened() {
    }

    public void projectClosed() {
    }

    @NotNull
    public String getComponentName() {
        if ("CodeStyleSettingsManager" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/codeStyle/CodeStyleSettingsManager.getComponentName must not return null");
        }
        return "CodeStyleSettingsManager";
    }

    public void setTemporarySettings(CodeStyleSettings settings) {
        this.myTemporarySettings = settings;
    }

    public void dropTemporarySettings() {
        this.myTemporarySettings = null;
    }
}

