/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.profile.Profile;
import com.intellij.profile.ProfileChangeAdapter;
import com.intellij.profile.ProfileManager;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public abstract class ApplicationProfileManager
implements ProfileManager {
    @Nullable
    public static ApplicationProfileManager getProfileManager(String type) {
        ApplicationProfileManager[] components;
        for (ApplicationProfileManager manager : components = ApplicationManager.getApplication().getComponents(ApplicationProfileManager.class)) {
            if (manager.getProfileType().compareTo(type) != 0) continue;
            return manager;
        }
        return null;
    }

    public static Set<String> getRegisteredProfileTypes() {
        ApplicationProfileManager[] components;
        HashSet<String> result = new HashSet<String>();
        for (ApplicationProfileManager manager : components = ApplicationManager.getApplication().getComponents(ApplicationProfileManager.class)) {
            result.add(manager.getProfileType());
        }
        return result;
    }

    public abstract Profile createProfile();

    public abstract void addProfileChangeListener(ProfileChangeAdapter var1);

    public abstract void addProfileChangeListener(ProfileChangeAdapter var1, Disposable var2);

    public abstract void removeProfileChangeListener(ProfileChangeAdapter var1);

    public abstract void fireProfileChanged(Profile var1);

    public abstract void fireProfileChanged(Profile var1, Profile var2, @Nullable NamedScope var3);

    public abstract void setRootProfile(String var1);

    public abstract Profile getRootProfile();

    public abstract void addProfile(Profile var1);

    @Override
    @Nullable
    public NamedScopesHolder getScopesManager() {
        return null;
    }
}

