/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.ui.SeparatorFactory;
import com.intellij.ui.TextComponentUndoProvider;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.Nullable;

public class CommitMessage
extends JPanel
implements Disposable {
    private final JTextArea myCommentArea = new JTextArea();

    public CommitMessage() {
        super(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane(this.myCommentArea);
        scrollPane.setPreferredSize(this.myCommentArea.getPreferredSize());
        this.add((Component)scrollPane, "Center");
        JPanel labelPanel = new JPanel(new BorderLayout());
        labelPanel.setBorder(BorderFactory.createEmptyBorder());
        JComponent separator = SeparatorFactory.createSeparator(VcsBundle.message("label.commit.comment", new Object[0]), this.myCommentArea);
        JPanel separatorPanel = new JPanel(new BorderLayout());
        separatorPanel.add((Component)separator, "South");
        separatorPanel.add(Box.createVerticalGlue(), "North");
        labelPanel.add((Component)separatorPanel, "Center");
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("unknown", CommitMessage.getToolbarActions(), true);
        toolbar.updateActionsImmediately();
        toolbar.setReservePlaceAutoPopupIcon(false);
        toolbar.getComponent().setBorder(BorderFactory.createEmptyBorder());
        labelPanel.add((Component)toolbar.getComponent(), "East");
        this.add((Component)labelPanel, "North");
        this.setBorder(BorderFactory.createEmptyBorder());
        TextComponentUndoProvider textComponentUndoProvider = new TextComponentUndoProvider(this.myCommentArea);
        Disposer.register((Disposable)this, (Disposable)textComponentUndoProvider);
    }

    @Nullable
    public static ActionGroup getToolbarActions() {
        return (ActionGroup)ActionManager.getInstance().getAction("Vcs.MessageActionGroup");
    }

    public JTextComponent getTextField() {
        return this.myCommentArea;
    }

    public void setText(String initialMessage) {
        this.myCommentArea.setText(initialMessage);
    }

    public String getComment() {
        int end;
        String s = this.myCommentArea.getText();
        for (end = s.length(); end > 0 && Character.isSpaceChar(s.charAt(end - 1)); --end) {
        }
        return s.substring(0, end);
    }

    public void init() {
        this.myCommentArea.setRows(3);
        this.myCommentArea.setWrapStyleWord(true);
        this.myCommentArea.setLineWrap(true);
        this.myCommentArea.setSelectionStart(0);
        this.myCommentArea.setSelectionEnd(this.myCommentArea.getText().length());
    }

    public void requestFocusInMessage() {
        this.myCommentArea.requestFocus();
        this.myCommentArea.selectAll();
    }

    public void dispose() {
    }
}

