/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.Semaphore;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Future;

public class ConcurrentTasks<T> {
    private volatile boolean myResultKnown;
    private final Semaphore mySemaphore;
    private volatile T myResult;
    private volatile int myCntAlive;
    private final ProgressIndicator myParentIndicator;
    private final List<Consumer<Consumer<T>>> myTasks;

    public void compute() {
        final EmptyProgressIndicator pi = new EmptyProgressIndicator(){

            @Override
            public void checkCanceled() {
                if (ConcurrentTasks.this.myResultKnown || ConcurrentTasks.this.myParentIndicator != null && ConcurrentTasks.this.myParentIndicator.isCanceled()) {
                    super.cancel();
                }
                super.checkCanceled();
            }
        };
        this.myCntAlive = this.myTasks.size();
        this.mySemaphore.down();
        LinkedList futures = new LinkedList();
        for (final Consumer<Consumer<T>> consumer : this.myTasks) {
            if (this.myResultKnown) {
                --this.myCntAlive;
                continue;
            }
            final Runnable computableProxy = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        consumer.consume((Object)new Consumer<T>(){

                            public void consume(T t) {
                                if (ConcurrentTasks.this.myResultKnown) {
                                    return;
                                }
                                ConcurrentTasks.this.myResult = t;
                                ConcurrentTasks.this.myResultKnown = true;
                            }
                        });
                    }
                    finally {
                        --ConcurrentTasks.this.myCntAlive;
                        if (ConcurrentTasks.this.myCntAlive == 0 || ConcurrentTasks.this.myResultKnown) {
                            ConcurrentTasks.this.mySemaphore.up();
                        }
                    }
                }
            };
            Future<?> future = ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                @Override
                public void run() {
                    ProgressManager.getInstance().runProcess(computableProxy, pi);
                }
            });
            futures.add(future);
        }
        while (!this.myResultKnown && this.myCntAlive > 0) {
            pi.checkCanceled();
            this.mySemaphore.waitFor(300L);
        }
        for (Future future : futures) {
            if (future.isCancelled() || future.isDone()) continue;
            future.cancel(true);
        }
    }

    public boolean isResultKnown() {
        return this.myResultKnown;
    }

    public T getResult() {
        return this.myResult;
    }

    public ConcurrentTasks(ProgressIndicator parentIndicator, Consumer<Consumer<T>> ... tasks) {
        this.myParentIndicator = parentIndicator;
        this.myTasks = Arrays.asList(tasks);
        this.mySemaphore = new Semaphore();
    }

    public ConcurrentTasks(ProgressIndicator parentIndicator, List<Consumer<Consumer<T>>> tasks) {
        this.myParentIndicator = parentIndicator;
        this.myTasks = tasks;
        this.mySemaphore = new Semaphore();
    }
}

