/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.popup.util;

import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseListPopupStep<T>
extends BaseStep<T>
implements ListPopupStep<T> {
    private String myTitle;
    private List<T> myValues;
    private List<Icon> myIcons;
    private int myDefaultOptionIndex;

    public BaseListPopupStep(String aTitle, T[] aValues) {
        this(aTitle, aValues, new Icon[0]);
    }

    public BaseListPopupStep(String aTitle, List<? extends T> aValues) {
        this(aTitle, aValues, new ArrayList<Icon>());
    }

    public BaseListPopupStep(String aTitle, T[] aValues, Icon[] aIcons) {
        this(aTitle, Arrays.asList(aValues), Arrays.asList(aIcons));
    }

    public BaseListPopupStep(String aTitle, @NotNull List<? extends T> aValues, Icon aSameIcon) {
        if (aValues == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/ui/popup/util/BaseListPopupStep.<init> must not be null");
        }
        this.myDefaultOptionIndex = -1;
        ArrayList<Icon> icons = new ArrayList<Icon>();
        for (int i = 0; i < aValues.size(); ++i) {
            icons.add(aSameIcon);
        }
        this.init(aTitle, aValues, icons);
    }

    public BaseListPopupStep(String aTitle, @NotNull List<? extends T> aValues, List<Icon> aIcons) {
        if (aValues == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/ui/popup/util/BaseListPopupStep.<init> must not be null");
        }
        this.myDefaultOptionIndex = -1;
        this.init(aTitle, aValues, aIcons);
    }

    protected BaseListPopupStep() {
        this.myDefaultOptionIndex = -1;
    }

    protected final void init(@Nullable String aTitle, @NotNull List<? extends T> aValues, @Nullable List<Icon> aIcons) {
        if (aValues == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/ui/popup/util/BaseListPopupStep.init must not be null");
        }
        this.myTitle = aTitle;
        this.myValues = new ArrayList<T>(aValues);
        this.myIcons = aIcons;
    }

    @Override
    @Nullable
    public final String getTitle() {
        return this.myTitle;
    }

    @Override
    @NotNull
    public final List<T> getValues() {
        List<T> list = this.myValues;
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/ui/popup/util/BaseListPopupStep.getValues must not return null");
        }
        return list;
    }

    @Override
    public PopupStep onChosen(T selectedValue, boolean finalChoice) {
        return FINAL_CHOICE;
    }

    @Override
    public Icon getIconFor(T aValue) {
        int index = this.myValues.indexOf(aValue);
        if (index != -1 && this.myIcons != null && index < this.myIcons.size()) {
            return this.myIcons.get(index);
        }
        return null;
    }

    @Override
    @NotNull
    public String getTextFor(T value) {
        String string = value.toString();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/ui/popup/util/BaseListPopupStep.getTextFor must not return null");
        }
        return string;
    }

    @Override
    @Nullable
    public ListSeparator getSeparatorAbove(T value) {
        return null;
    }

    @Override
    public boolean isSelectable(T value) {
        return true;
    }

    @Override
    public boolean hasSubstep(T selectedValue) {
        return false;
    }

    @Override
    public void canceled() {
    }

    public void setDefaultOptionIndex(int aDefaultOptionIndex) {
        this.myDefaultOptionIndex = aDefaultOptionIndex;
    }

    @Override
    public int getDefaultOptionIndex() {
        return this.myDefaultOptionIndex;
    }
}

